#include <iostream.h>
#include <pthread.h>
#include "ndds/NDDS.h"
#include "publisherThread.h"
#include "nddsMsgNames.h"
#include "SAS_Config.h"

publisherThreadData::publisherThreadData() {
  this->threadDone = 0;
  this->publisherThreadState = PUBLISHER_THREAD_STOP;
}

// *** Template for how to instantiate all messages you'll want to produce in subclasses of publisherThread.
//hiResDerivedState hiResDerived;
//hiResDerivedState *p_hiResDerived = &hiResDerived;

// *** Template for you to instantiate the telemetry thread data
//publisherThreadParam hiResPublisherThreadData;

// *** This is a template -- you need to set the threadParam to some global variable you've declared above.
publisherThread::publisherThread(float period, publisherThreadData *param) {
  threadParam = param;
  threadParam->period = period;
  telThread = (pthread_t *)calloc(1, sizeof(pthread_t));
}

publisherThread::~publisherThread() {
  threadParam->publisherThreadState = PUBLISHER_THREAD_STOP;
  while(!threadParam->threadDone) {}
}

void publisherThread::start() {
  threadParam->publisherThreadState = PUBLISHER_THREAD_START;
  
  int nddsDomain;
  if(!getSAS_Config(NDDS_DOMAIN, nddsDomain)) {
    cerr << "[publisherThread] ERROR: Cannot read " << NDDS_DOMAIN << " from config file!" << endl;
    threadParam->publisherThreadState = PUBLISHER_THREAD_STOP;
    return;
  }

  NddsInit(nddsDomain, NULL);

  registerNddsMsgs();
  
  if(pthread_create(telThread, NULL, produceTelemetry, NULL) != 0) {
    cerr << "[publisherThread] ERROR: Cannot start thread!" << endl;
    threadParam->publisherThreadState = PUBLISHER_THREAD_STOP;
  } 
}

void publisherThread::produceTelemetry() {
  cerr << "[publisherThread] Starting up publisher thread...";
  NDDSPublication pub = createNddsPublication();
  cerr << "done!!" << endl;
  threadParam->threadDone = 0;
  cerr << "done!!" << endl;

  while(threadParam->publisherThreadState == PUBLISHER_THREAD_START) {
    NddsPublicationSend(pub);
    NddsUtilitySleep(threadParam->period);
  }

  cerr << "[publisherThread] Exiting thread...";
  threadParam->publisherThreadState = PUBLISHER_THREAD_STOP;
  threadParam->threadDone = 1;
  cerr << "done!" << endl;

  pthread_exit(NULL);
}

void publisherThread::stop() {
  threadParam->publisherThreadState = PUBLISHER_THREAD_STOP; // This should stop the while() loop in start().
}

PUBLISHER_THREAD_STATE publisherThread::getState() {
  return(threadParam->publisherThreadState);
}
