/* FILE: ppm.h
   CREATED: 4/13/99
   AUTHOR: Michael Wagner
   DESCRIPTION: This file defines the ppm class, which is used to work
     with PPM files. Currently, only P5 and P6 format PPM files are 
     supported. Also, note that the PPM format and comment must be less than
     a maximum length!
*/

#ifndef __PPM_H__
#define __PPM_H__

#define MAX_PPM_FORMAT_LENGTH 10
#define MAX_PPM_COMMENT_LENGTH 8096
#define PPM_COMMENT_CHAR '#'

class ppm {
 public:
  ppm();
  ~ppm();

  int read(char *filename);  // Returns 1 on success, 0 on failure
  int readMem(unsigned char *image, int numRows, 
	      int numCols, int numBytes);  /* Returns 1 on success, 0 on failure
					      image is assumed to be a pointer to 
					      an RGB image in memory */
  
  int write(char *filename); // Returns 1 on success, 0 on failure
  int threshhold(int minBlue, int minRed, int minGreen);
  int threshhold(int minIntensity);
  unsigned char *getRow(int rowNum);
  unsigned char *getCol(int colNum);
  int getRowSize();
  int getColSize();
  
  char format[MAX_PPM_FORMAT_LENGTH];
  char comment[MAX_PPM_COMMENT_LENGTH];
  int numRows;
  int numCols;
  int pixelDepth;
  unsigned char *red;
  unsigned char *green;
  unsigned char *blue;
  
};

#endif /* __PPM_H__ */
