#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <stdlib.h>
#include "SAS_Config.h"

// string version
int getSAS_Config(char *name, char *val, int &valLength) {
  if(NULL == getenv("NOMAD_HOME")) {
    cerr << "[SAS_Config] ERROR: NOMAD_HOME environment variable not set!" << endl;
    return(0);
  }
  
  char filename[1000];
  sprintf(filename, "%s/%s", getenv("NOMAD_HOME"), SAS_CONFIG_FILE);

  fstream infile(filename, ios::in);
  
  if(infile.fail()) {
    cerr << "[SAS_Config] ERROR: Failed opening input file!" << endl;
    return(0);
  }
  
  // Read in variables from infile.
  int numVars;
  char tmpName[MAX_CONFIG_NAME_LEN];
  char tmpVal[MAX_CONFIG_VAL_LEN];

  infile >> numVars;
  for(int i=0; i < numVars; i++) {
    infile >> tmpName;
    infile >> tmpVal;
    if(strcmp(tmpName, name) == 0) {
      infile.close();
      strcpy(val, tmpVal);
      valLength = strlen(val);
      return(1);
    }
  }
  
  infile.close();
  return(0);
}

// int version
int getSAS_Config(char *name, int &val) {
  char *tmp = new char[MAX_CONFIG_VAL_LEN];
  int tmpLen;
  int retVal = getSAS_Config(name, tmp, tmpLen);
  val = atoi(tmp); delete(tmp);
  return(retVal);
}

// long version
int getSAS_Config(char *name, long &val) {
  char *tmp = new char[MAX_CONFIG_VAL_LEN];
  int tmpLen;
  int retVal = getSAS_Config(name, tmp, tmpLen);
  val = atol(tmp); delete(tmp);
  return(retVal);
}

// float version
int getSAS_Config(char *name, float &val) {
  char *tmp = new char[MAX_CONFIG_VAL_LEN];
  int tmpLen;
  int retVal = getSAS_Config(name, tmp, tmpLen);
  val = atof(tmp); delete(tmp);
  return(retVal);
}

// double version
int getSAS_Config(char *name, double &val) {
  char *tmp = new char[MAX_CONFIG_VAL_LEN];
  int tmpLen;
  int retVal = getSAS_Config(name, tmp, tmpLen);
  val = (double)atof(tmp); delete(tmp);
  return(retVal);
}

// char version
int getSAS_Config(char *name, char &val) {
  char *tmp = new char[MAX_CONFIG_VAL_LEN];
  int tmpLen;
  int retVal = getSAS_Config(name, tmp, tmpLen);
  val = tmp[0]; delete(tmp);
  return(retVal);
}

