#ifndef __SAS_CONFIG_H__
#define __SAS_CONFIG_H__

// Here is a list of registered variables in the config file
#define PTU_SERIAL_PORT "ptuSerialPort"
#define LENS_CONTROLLER_SERIAL_PORT "lensControllerSerialPort"
#define NDDS_DOMAIN "NDDS_Domain"
#define TARGET_ACQ_START_ROW "targetAcqStartRow"
#define TARGET_ACQ_STOP_ROW "targetAcqStopRow"
#define TELEMETRY_LOG_PERIOD "telemetryLogPeriod"
#define RED_THRESHOLD_RG_COEFF "redThreshRG_Coeff"
#define RED_THRESHOLD_RB_COEFF "redThreshRB_Coeff"

#define SAS_CONFIG_FILE "SAS_Config.dat"
#define MAX_CONFIG_NAME_LEN 128
#define MAX_CONFIG_VAL_LEN 128

typedef struct {
  char  **configVal;
  char  **configName;
  int numVars;
} SAS_ConfigStruct;

// All of these return 1 on success, 0 on failure
int getSAS_Config(char *name, int &val);
int getSAS_Config(char *name, long &val);
int getSAS_Config(char *name, float &val);
int getSAS_Config(char *name, double &val);
int getSAS_Config(char *name, char &val);
int getSAS_Config(char *name, char *val, int &valLength);

#endif /* __SAS_CONFIG_H__ */
