#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <stdlib.h>
#include "SAS_Config.h"

int main(int argc, char *argv[]) {
  if(NULL == getenv("NOMAD_HOME")) {
    cerr << "[SAS_Config] ERROR: NOMAD_HOME environment variable not set!" << endl;
    return(-1);
  }

  // SAS configuration variables 
  SAS_ConfigStruct config;

  char filename[1000];
  sprintf(filename, "%s/%s", getenv("NOMAD_HOME"), SAS_CONFIG_FILE);
  fstream infile(filename, ios::in);

  if(infile.fail()) {
    cerr << "[SAS_Config] ERROR: Failed opening input file!" << endl;
    return(-1);
  }

  // Read in variables from infile.
  infile >> config.numVars;
  config.configName = new (char *)[config.numVars];
  config.configVal  = new (char *)[config.numVars];
  for(int i=0; i < config.numVars; i++) {
    config.configName[i] = new char[MAX_CONFIG_NAME_LEN];
    config.configVal[i] = new char[MAX_CONFIG_VAL_LEN];
    infile >> config.configName[i];
    infile >> config.configVal[i];
  }

  infile.close();

  char command[1000];
  // Make temporary backup file
  sprintf(command, "\\cp %s/%s %s/%s.bak", getenv("NOMAD_HOME"), SAS_CONFIG_FILE, getenv("NOMAD_HOME"), SAS_CONFIG_FILE);
  system(command);

  fstream outfile(filename, ios::out);

  if(outfile.fail()) {
    cerr << "[SAS_Config] ERROR: Failed opening output file!" << endl;
    return(-1);
  }

  int editNum;
  int changed = 0;
  while(1) {

    // Prompt user for changes
    cout << "*** SAS Configuration ***" << endl;
    cout << endl;
    for(int i=0; i < config.numVars; i++) {
      cout << "(" << i+1 << ") " << config.configName[i] << ": " << config.configVal[i] << endl;
    }
    cout << endl;
    cout << "Edit which variable? (0 to quit): ";
    
    cin >> editNum;

    if(editNum == 0) {
      break;
    } else if(editNum > config.numVars) {
      cout << "Illegal variable number!" << endl;
    } else {
      cout << endl << config.configName[editNum-1] << " = ";
      cin >> config.configVal[editNum-1];
      changed = 1;
    }

  }

  outfile << config.numVars << endl;
  for(int i=0; i < config.numVars; i++) {
    outfile << config.configName[i] << " ";
    outfile << config.configVal[i] << endl;
  }

  outfile.close();

  if(!changed) {
    // Remove backup file, it's unnecessary
    sprintf(command, "\\rm %s/%s.bak", getenv("NOMAD_HOME"), SAS_CONFIG_FILE);
    system(command);
  } 

  cout << "[SAS_Config] Successfully wrote configuration file " << SAS_CONFIG_FILE << endl;

  for(int i=0; i < config.numVars; i++) {
    delete(config.configVal[i]);
    delete(config.configName[i]);
  }
  delete(config.configVal);
  delete(config.configName);

  return(0);
}


