#ifndef __NDDS_COMMS_H__
#define __NDDS_COMMS_H__

#include "ndds/NDDS.h"
#include "dbRecord.h"

#define DB_MIN_WAIT_TIME 0.1f
#define DB_MAX_WAIT_TIME 5.0f
#define DB_NOTIFY_DEADLINE 10.0f
#define DB_NOTIFY_MIN_SEPARATION 0.0f

RTIBool dbNotifyCallback(NDDSRecvInfo *issue);

class ClassifierNddsComms {
 public:
  ClassifierNddsComms();
  ~ClassifierNddsComms();

  int StartNDDS(); /* Returns 1 on success, 0 on failure */

  /* This method should be used to check for new data in the database.
     It abstracts the dbNotify messages, and copies the dbRecord information
     object only if it has new information interesting to the classifier. 
     Returns 1 if new data exists, 0 otherwise. */
  int DatabaseHasNewInfo(dbRecord &record);

  /* These methods are used to interface with the database, and they
     return 1 on success, 0 on failure. In all cases, readingNum starts
     with index 0. */
  int GetRecord(int targetID, int driverNum, dbRecord &record);
  int PutRecord(int targetID, int driverNum, const dbRecord &record);
  int GetImageParameters(const dbRecord &record, int readingNum,
			 float &originRow, float &originCol,
			 float &scaleRow, float &scaleCol
			 /*,vector &features*/);
  int GetSpectrumParameters(const dbRecord &record, int readingNum
			    /*,vector &features*/);
  int GetMetalDetectorParameters(const dbRecord &record, int readingNum
				 /*,vector &features*/);
  int InsertFeatures(dbRecord &record, int readingNum
		     /*, vector features*/);
  int GetReadingDataFile(const dbRecord &record, int readingNum, char &filename);

 private:
  queue<dbNotify *> q;
  dbNotify *dbNotifyMsg;
  NDDSSubscription dbNotifyfSub;
  dbRequest *dbRequestMsg;
  dbReply *dbReplyMsg;
  NDDSClient dbClient;
  NDDSClientReplyStatus dbClientStatus;
};

