/* mangen panoText \- NDDS methods for panoText type
   banner = ==========
  
   This file is derived from code automatically generated by nddsgen.

   modification history
   ------------ -------
   19a,29aug95,gpc Mofified for version 1.9
   19a,20Aug95,gpc Auto-gen code for panoTextAllocate and panoTextFree
   RTI,30may94,sas cleanup.
   RTI,02apr94,gpc Auto-generated code template written.
 */

static char copyright_rti[] = 
"(c) Copyright, Real-Time Innovations, Inc., 1994.  All rights reserved.";

/*
DESCRIPTION:
This file implements the NDDS methods required to declare a panoText 
type to NDDS. This file was automatically generated by the 'nddsgen'
code generator from a specification of the panoText type given in
the XDR language. See the man pages on 'nddsgen' and 'NddsXDR'.

This file was generated with the following steps:

(1) A description of the type panoText was written in a file
named panoText.x (NOTE: the .x termination which is standard
for this files is required.). This description uses the XDR language,
which resembles "C"-like structure-type declarations. More information 
and examples on how to write these ".x" files can be found in the 
man page for 'nddsgen'.

(2) 'nddsgen' was run on the panoText.x file. The command was:
    d:\rti\ndds.1.11d\bin\i86Win32\nddsgen panoText.x -t panoTextStruct -n panoText

This created the panoText_stubs.c, panoText_xdr.c, panoText.h 
and panoText_test.c files.

(3) The panoText_stubs.c was copied into panoText.c; 
this file contains the functions, panoTextSeralize(), 
panoTextDeserialize(), and panoTextPrint() that are 
required to register the panoText type with NDDS. 

(4) The user may want to fill in the code for the panoTextPrint()
function if he/she wants NDDS to print the panoText automatically
in certain situations. This isn't required.

(5) The file panoText.c also contains the function 
panoTextInit(). This function will register the 
panoText type with NDDS.

(6) The panoText_test.c contains code to test the 
serialization/deserialization functions. It is advisable to 
compile and run this program to verify proper operation.

SEE ALSO:
nddsgen(1), NddsXDR(2), Ndds(2)
  panoTextNddsRegister(3)
--------------------------------------------------------------------------- */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "panoText.h"

/* ========================================================================
   panoTextSerialize \- NDDS serialization method for panoText

   Required NDDS method to serialize an panoText into NDDSXDRStream 
   buffer.
   The data will be deserialized by the panoTextDeserialize() function.

   The 'options' may be defined and used for customizing serialization
   for different situations. Often (as in this case) they are simply 
   ignored.
 */
boolean panoTextSerialize(NDDSXDRStream nddsds,
			      panoText nddspanoText,
			      int options)
{
    return xdr_panoTextStruct(NddsXDRGetSerializingStream(nddsds),
			       nddspanoText);
}

/* ========================================================================
   panoTextDeserialize \- NDDS deserialization method for panoText 
   
   Required NDDS method to deserialize the data from an NDDSXDRStream buffer.
   The data was serialized by the panoTextSerialize() function.

   If outArray==NULL (null pointer), this function will create a
   panoText of the appropriate size to hold the data 
   (as required by NDDS).

   Returns the output array or NULL if an error occurred
 */
panoText panoTextDeserialize(panoText nddspanoText,
				     NDDSXDRStream nddsds)
{
    int allocated = FALSE;

    if (nddspanoText == NULL) {
	allocated = TRUE;
	nddspanoText = calloc(1, sizeof(*nddspanoText));
    }

    if (!xdr_panoTextStruct(NddsXDRGetDeserializingStream(nddsds),
			     nddspanoText))  {
	if (allocated) {
	    free(nddspanoText);
	}
	return NULL;
    }
    
    return nddspanoText;
}

/* ========================================================================
   panoTextPrint \- NDDS Print method for panoText objects

   Optional NDDS method to print the contents of an panoText.

   Note that if this method *must* handle the case where the object
   is NULL.
 */
panoText panoTextPrint(panoText nddspanoText)
{
    /* Do not remove. panoTextPrint must handle a NULL 
       panoText 
       */
    if (nddspanoText==NULL) {
	printf("panoText: (null)\n");
	return NULL;
    }

    /* Replace by custom code if desired */
    if (!NddsPrint_panoTextStruct(nddspanoText, "panoText", 0)) {
	printf("NddsPrint_panoTextStruct() failed on %p\n", nddspanoText);
	return NULL;
    }

    /* Do not remove the return value */
    return nddspanoText;
}

/* ========================================================================
   panoTextAllocate \- NDDS Allocate method for panoText objects

   Optional NDDS method to allocate an NDDS object of type panoText.

   If registered within panoTextNddsRegister(), this method will be 
   invoked as a result of pattern subscriptions. When the NDDS agent 
   subscribes to a production that matches the requested pattern, it
   needs to create a new object of the corresponding type to hold the 
   updates when they come. 
   It is for this purpose that panoTextAllocate() is used.

   This method is not always required because panoTextDeserialize()
   is usually able to allocate the object itself. There are however
   some cases (notably strings) for which the allocation provided
   by panoTextDeserialize() isn't sufficient. Registration
   of panoTextAllocate() allows to override the default allocation
   provided by panoTextDeserialize().

   If this method is to be used, it must passed to NddsTypeRegister()
   (in function panoTextNddsRegister()) instead of the default
   NULL method.

   This routine gets passed the type and name of the object instance and
   the parameter provided by the user passed in the 
   NddsConsumerAddSubscription() call.
 */
panoText panoTextAllocate(const char *type, const char *name,void *userParam)
{
    panoText nddspanoText;

    nddspanoText = (panoText)calloc(1, sizeof(*nddspanoText));
    {
		/* Add the custom allocation of entries in the structure here */
    	nddspanoText->data=(unsigned char *)malloc(2048);
	}

    return nddspanoText;
}

/* ========================================================================
   panoTextFree \- NDDS Free method for panoText objects

   Optional NDDS method to Free an NDDS object of type panoText.

   This method is not used in the current version of NDDS.
 */
boolean panoTextFree(panoText inst,
			 const char *type, const char *name,
			 void *userParam)
{
    return TRUE;
}

/* ========================================================================
   panoTextNddsRegister \- Install panoText type to NDDS
   
   This function will register an panoText type with NDDS.   
   Registration must happen before any reference to the panoText 
   type is given to NDDS.
 */
void panoTextNddsRegister(void)
{
   NddsTypeRegister("panoText",
		    (SerializeMethodType)panoTextSerialize,
		    (DeserializeMethodType)panoTextDeserialize,
		    (PrintMethodType)panoTextPrint,
		    (AllocateMethodType)NULL,
		    (FreeMethodType)NULL);
}

