#define PANO_NAME "panospheric"
#define PANO_RECEIVE_NAME "panoReceive"
#define PANO_TEXT_NAME "panoText"

#define EXPOSURE_MINIMUM   0x4
#define EXPOSURE_MAXIMUM   0x780
#define ADJUSTMENT_MINIMUM 0x1
#define ADJUSTMENT_MAXIMUM 0x80
#define SATURATION_MINIMUM 1
#define SATURATION_MAXIMUM 100
#define AVGPIXEL_MINIMUM   100
#define AVGPIXEL_MAXIMUM   4000

#define QUALITY_MINIMUM    1
#define QUALITY_MAXIMUM    200
#define MAGNIFY_MINIMUM    4
#define MAGNIFY_MAXIMUM    4
#define COMP8_MINIMUM      0
#define COMP8_MAXIMUM      8

// --------------------------
// CONSTANTS for the PANORECEIVER

#define PE_ERROR         1
#define PE_LOG           2
#define PE_HANDSHAKE     3

#define PANO_START       1
#define PANO_STOP        2
#define PANO_REPORT      3
#define PANO_CONFIG      4
#define PANO_SNAPSHOT    5
#define PANO_CAMSWITCH   6
#define PANO_HANDSHAKE   7
#define PANO_EXIT        8

#define PANO_SNAPSHOT_RAW     501
#define PANO_SNAPSHOT_RGB     502
#define PANO_SNAPSHOT_RGBOLD  503
#define PANO_SNAPSHOT_COMPOLD 504
#define PANO_SNAPSHOT_COMPRGB 505

#define PANO_CONFIG_NDDS      401
#define PANO_CONFIG_COMPRESS2 402
#define PANO_CONFIG_COMPRESS1 403
#define PANO_CONFIG_COMPFOCUS 404
#define PANO_CONFIG_COMPSAM   405
#define PANO_CONFIG_EXPOSURE  406
#define PANO_CONFIG_OLDCOLOR  407

#define PANO_CONFIG_CMP_QUALITY    4040
#define PANO_CONFIG_CMP_CONTROL    4041
#define PANO_CONFIG_CMP_ENCODER    4042
#define PANO_CONFIG_CMP_ENCPATH    4043

#define PANO_CONFIG_CMP_EDGE       4050
#define PANO_CONFIG_CMP_CONTRAST   4051
#define PANO_CONFIG_CMP_FOCUSWGHT  4052
#define PANO_CONFIG_CMP_BLOCKSIZE  4053

#define PANO_CONFIG_EX_SETTING     4060
#define PANO_CONFIG_EX_ADJUST      4061
#define PANO_CONFIG_EX_SATURATION  4062
#define PANO_CONFIG_EX_AVGPIXEL    4063

#define PANO_CONFIG_OC_ACTIVE      4071
#define PANO_CONFIG_OC_INACTIVE    4072

#define PANO_CAMSWITCH_PANO   601
#define PANO_CAMSWITCH_BACK   602

#define PANO_CONFIG_BOXLEFT        0
#define PANO_CONFIG_BOXTOP         1
#define PANO_CONFIG_BOXRIGHT       2
#define PANO_CONFIG_BOXBOTTOM      3

#define PANO_TYPEFLAG_IMAGE   1
#define PANO_TYPEFLAG_REPORT  2
#define PANO_TYPEFLAG_ERROR   3
#define PANO_TYPEFLAG_RAW     4
#define PANO_TYPEFLAG_RED     5
#define PANO_TYPEFLAG_GREEN   6
#define PANO_TYPEFLAG_BLUE    7
#define PANO_TYPEFLAG_RGB     8
#define PANO_TYPEFLAG_CMPRED  9
#define PANO_TYPEFLAG_CMPBLUE 10
#define PANO_TYPEFLAG_CMPGREEN 11
#define PANO_TYPEFLAG_HANDSHAKE 12
