
#include <stdio.h>
#include "NDDS.h"
#include "panoReceive.h"
#include "panoText.h"
#include "NomadNddsDomain.h"
#include "constants.h"
#include "swi32.h"

int sendcount;
int receivecount;
int MenuPrint();
boolean ParseSelection(int input,panoReceive ctrlMessage);
boolean ParseConfig(int input, panoReceive ctrlMessage);
void panoTextReceive();
NDDSObjectInstance panoTextCallback(NDDSUpdateInfo update);
void TextThread();
void DoSample();
void EndTextThread();
void InitTextThread();
int ConfigPrint();
boolean ParseSnapshot(int input, panoReceive ctrlMessage);
int SnapshotPrint();
boolean panoExit=FALSE;
panoReceive ctrlMessage;
HANDLE hTextThread;
HANDLE TextEvent;

NDDSConsumer panoTextConsumer;
panoTextStruct p_panoText;
  NDDSProducer panoProducer;

void DoSample()
{
	int i ;
	NddsProducerSample(panoProducer);
	sendcount++;
	NddsPrint_panoReceiveStruct(ctrlMessage, "Sending: ", 0);
	Sleep(3000);
	for (i=0;i<5 && (receivecount<sendcount);i++)
	{
		NddsProducerSample(panoProducer);
		Sleep(3000);
	}
	if (i==10) {printf("SEND FAILED.\n");sendcount--;}
	return;
}

void main(int argc, char *argv[])
{
    int i;
    unsigned int send_period_us = 4000000; /* 4 seconds */
 	NDDSDomain nddsDomain;
    NDDSMulticastInfoStorage multicastInfo; /* domain and TTL */
	
    float persistence = 15.0f;
    float strength = 1.0f;

	sendcount=0;
	receivecount=0;

	nddsDomain=NOMAD_NDDS_DOMAIN;
	multicastInfo.Domain = NOMAD_NDDS_MULTICAST_DOMAIN;
	multicastInfo.TTL = NOMAD_NDDS_MULTICAST_TTL;
	NddsVerbositySet(0);
	NddsVerbosityErrorSet(0);
	NddsVerbosityDebugSet(0);
	NddsInit(nddsDomain, &multicastInfo);
	NddsPeerHostsSet("172.20.3.129:172.20.1.123");
   
    panoReceiveNddsRegister();

    ctrlMessage = (panoReceive)calloc(1, sizeof(*ctrlMessage));
    ctrlMessage->message = PANO_HANDSHAKE;
	ctrlMessage->flag = 0;
	for (i=0;i<4;i++) ctrlMessage->params[i] =0;


    panoProducer = NddsProducerCreate(PANO_NAME, NDDS_SYNCHRONOUS,
				      persistence, strength);

    NddsProducerProductionAdd(panoProducer, PANO_RECEIVE_NAME,
			      PANO_RECEIVE_NAME, ctrlMessage, 0, NULL, NULL, NULL, NULL);
	
	panoTextReceive();
	InitTextThread();

	printf("Welcome to the Murphospheric Control Panel (text version).\n");
	printf("Some of the numbers have been changed... take time to read.\n");
	printf("\n");

	DoSample();
	while (1)
	{
		if (ParseSelection(MenuPrint(),ctrlMessage))
		{
			DoSample();
		}
	}
	return;
}

void InitTextThread()
{
	DWORD TextThreadId;
	
	hTextThread = CreateThread( 
        NULL,						// no security attributes        
        0,							// use default stack size        
        (LPTHREAD_START_ROUTINE) TextThread, // thread function       
        NULL,						// argument to thread function   
        0,							// use default creation flags    
        &TextThreadId);			// returns the thread identifier 
	return;
}


void TextThread()
{
	DWORD evnt;
	TextEvent=CreateEvent(NULL,FALSE,FALSE,"ExitComp0Thread");
	while (1)
	{
		evnt=500;
		evnt = WaitForSingleObject(hTextThread, 200)-WAIT_OBJECT_0;
		if (evnt==0) return;
		NddsConsumerPoll(panoTextConsumer);	
	}
	return;
}

void panoTextReceive()
//This is based on the nddsgen consumer code snippets.
{
	panoTextNddsRegister();
	panoTextConsumer = NddsConsumerCreate(PANO_NAME, NDDS_POLLED, 1000.0f, 1.0f);
	NddsConsumerSubscriptionAdd(panoTextConsumer,PANO_TEXT_NAME,
		PANO_TEXT_NAME, (NDDSObjectInstance) &p_panoText,panoTextCallback,NULL);
	return;
}

NDDSObjectInstance panoTextCallback(NDDSUpdateInfo update)
{
	if (update->updateStatus != NDDS_FRESH_DATA) {return NULL;}
	//We have new data from NDDS, so lets process it

	if (p_panoText.type==PE_HANDSHAKE) receivecount++;
	NddsPrint_panoTextStruct(&p_panoText, "Received", 0);

	return update;
}
int MenuPrint()
{
	int input=0,i;
	ctrlMessage->message = PANO_HANDSHAKE;
	ctrlMessage->flag = 0;
	for (i=0;i<4;i++) ctrlMessage->params[i] =0;
	while(!input) 
	{
		printf("\nPlease select from the following numbered options:\n");
		printf("   %d. Start the panospheric acquisition process.\n",PANO_START);
		printf("   %d. Stop the panospheric acquisition process.\n", PANO_STOP);
		printf("   %d. Request a report of the murphospheric.\n",PANO_REPORT);
		printf("   %d. Adjust the configuration of the murphospheric.\n", PANO_CONFIG);
		printf("   %d. Take a snapshot rather than blast image stream.\n",PANO_SNAPSHOT);
		printf("   %d. Switch between the panospheric and back view cameras.\n",PANO_CAMSWITCH);
		printf("   %d. Send a handshake message.\n",PANO_HANDSHAKE);
		printf("   %d. Terminate the panospheric program (THIS IS NOT ADVISABLE).\n", PANO_EXIT);
		printf("   9. Exit this program.\n");
		fflush(stdin);
		scanf("%d",&input);
		if (input<1 || input>10)
		{
			printf("Sorry, invalid entry. Once more...\n   ");
			input=0;
		}
	}
	return input;
}

boolean ParseSelection(int input,panoReceive ctrlMessage)
{
	int parm0=0;
	fflush(stdin);
	switch(input)
	{
	case PANO_START:
		printf("Starting the Panospheric stream acquisition.\n");
		ctrlMessage->message=PANO_START;
		break;
	case PANO_STOP:
		printf("Stopping the Panospheric stream acquisition.\n");
		ctrlMessage->message=PANO_STOP;
		break;
	case PANO_REPORT:
		printf("Requesting a report of the murphospheric.\n");
		ctrlMessage->message=PANO_REPORT;
		break;
	case PANO_CONFIG:
		if (ParseConfig(ConfigPrint(),ctrlMessage)) ctrlMessage->message=PANO_CONFIG;
		else return FALSE;
		break;
	case PANO_SNAPSHOT:
		if (ParseSnapshot(SnapshotPrint(),ctrlMessage)) ctrlMessage->message=PANO_SNAPSHOT;
		else return FALSE;
		break;
	case PANO_CAMSWITCH:
		printf("Not currently supported by the receiver at this time.\n");
		printf("%d. Use panospheric camera.  %d. Use backview format.\n",
			PANO_CAMSWITCH_PANO%10,PANO_CAMSWITCH_BACK%10);
		scanf("%d",&parm0);
		if (parm0!=PANO_CAMSWITCH_PANO%10 && parm0!=PANO_CAMSWITCH_BACK%10)
			{printf("Input out of range.\n");return FALSE;}
		ctrlMessage->message = PANO_CAMSWITCH;
		ctrlMessage->flag = PANO_CAMSWITCH_PANO/10*10+parm0;
		break;
	case PANO_HANDSHAKE:
		printf("Sending a handshake request to the murphospheric.\n");
		ctrlMessage->message=PANO_HANDSHAKE;
		break;
	case PANO_EXIT:
		{
		int termconfirm=916407;
		printf("Attempting to terminate the murpshospheric program.\n");
		printf("Please input the following number to confirm: %d\n",termconfirm);
		scanf("%d",&parm0);
		if (parm0!=termconfirm) {printf("Improper termination number. ABORTED\n");return FALSE;}
		ctrlMessage->message=PANO_EXIT;
		break;
		}
	case 9:
		printf("Thank you for controlling the murphospheric.\nGoodbye for now\n");
		exit(1);
	default:
		printf("Option undefined.\n");
		return FALSE;
	}
	return TRUE;
}

int ConfigPrint()
{
	int input=0;
	while(!input) 
	{
		printf("    You have reached the config menu. Please choose a number.\n");
		printf("      %d. Adjust the BPS or the interpacket msec delay.\n",PANO_CONFIG_NDDS);
		printf("      %d. Adjust compression enhancement, focusweight or SAM.\n",PANO_CONFIG_COMPRESS2);
		printf("      %d. Adjust compression quality/ratio and encoding.\n",PANO_CONFIG_COMPRESS1);
		printf("      %d. Adjust the focus boxes in the compression.\n",PANO_CONFIG_COMPFOCUS);
		printf("      %d. Adjust the SAM blocks in the compression.\n",PANO_CONFIG_COMPSAM);
		printf("      %d. Adjust the exposure setting on the camera.\n",PANO_CONFIG_EXPOSURE);
		printf("      %d. Toggle between combined color image and separate RGB buffers.\n",PANO_CONFIG_OLDCOLOR);
		printf("      %d. Return to the main menu.\n",999);
		fflush(stdin);
		scanf("%d",&input);
		if (input<1 || input>1000)
		{
			printf("Sorry, invalid entry. Once more...\n   ");
			input=0;
		}
	}
	return input;
}

boolean ParseConfig(int input, panoReceive ctrlMessage)
{
	int parm0=0,parm1=0,parm2=0,parm3=0;
	fflush(stdin);
	switch(input)
	{
	case PANO_CONFIG_NDDS:
		printf("Please input a BPS between 1000 and 10000000. (or 0 to use msec delay)\n");
		scanf("%d",&input);
		if (input!=0 && (input<1000 || input>10000000))
		{
			printf("Input out of range.\n");
			return FALSE;
		}
		ctrlMessage->params[0] = input;
		printf("Please input a msec delay between 0 and 10000. [-1 = no change]\n");
		scanf("%d",&input);
		if (input<-1 || input>10000)
		{
			printf("Input out of range.\n");
			return FALSE;
		}
		ctrlMessage->params[1] = input;
		ctrlMessage->flag = PANO_CONFIG_NDDS;
		break;
	case PANO_CONFIG_COMPRESS1:
		printf("New quality percent or comp ratio: between %d and %d. [0 = no change]\n",
		     QUALITY_MINIMUM,QUALITY_MAXIMUM);
		scanf("%d",&parm0);
		if (parm0!=0 && (parm0<QUALITY_MINIMUM || parm0>QUALITY_MAXIMUM))
			{ printf("Input out of range.\n");return FALSE;}
		printf("%d. Use quality based comp.  %d. Use ratio based comp. [-1 = no change]\n",
			CR_QUALITY,CR_FLOOR);
		scanf("%d",&parm1);
		if (parm1!=(-1) && (parm1!=CR_QUALITY && parm1!=CR_FLOOR))
			{ printf("Input out of range.\n");return FALSE;}
		printf("Encoder: %d. SLOW, %d. NORMAL, %d. FAST, %d. FASTEST [-1 = no change]\n",
		     E_SLOW,E_NORMAL,E_FAST,E_FASTEST);
		scanf("%d",&parm2);
		if (parm2!=(-1) && (parm2!=E_SLOW && parm2!=E_NORMAL && parm2!=E_FAST && parm2!=E_FASTEST))
			{ printf("Input out of range.\n");return FALSE;}
		printf("Encode Path: %d. PATH1, %d. PATH2, %d. PATH3 [-1 = no change]\n",
		     P_PATH1+1,P_PATH2+1,P_PATH3+1);
		scanf("%d",&parm3);
		if (parm3!=(-1) && ((parm3!=P_PATH1+1) && (parm3!=P_PATH2+1) && (parm3!=P_PATH3+1) ))
			{ printf("Input out of range.\n");return FALSE;}
		ctrlMessage->flag = PANO_CONFIG_COMPRESS1;
		ctrlMessage->params[PANO_CONFIG_CMP_QUALITY%10] = parm0;
		ctrlMessage->params[PANO_CONFIG_CMP_CONTROL%10] = parm1;
		ctrlMessage->params[PANO_CONFIG_CMP_ENCODER%10] = parm2;
		ctrlMessage->params[PANO_CONFIG_CMP_ENCPATH%10] = parm3-1;
		break;
	case PANO_CONFIG_COMPRESS2:
		printf("New edge enhance setting: between %d and %d (max). [-1 = no change]\n",
		     COMP8_MINIMUM,COMP8_MAXIMUM);
		scanf("%d",&parm0);
		if (parm0!=(-1) && (parm0<COMP8_MINIMUM || parm0>COMP8_MAXIMUM))
			{ printf("Input out of range.\n");return FALSE;}
		printf("New contrast enhance setting: between %d and %d (max). [-1 = no change]\n",
		     COMP8_MINIMUM,COMP8_MAXIMUM);
		scanf("%d",&parm1);
		if (parm1!=(-1) && (parm1<COMP8_MINIMUM || parm1>COMP8_MAXIMUM))
			{ printf("Input out of range.\n");return FALSE;}
		printf("New focus weight: between %d and %d (max). [-1 = no change]\n",
		COMP8_MINIMUM,COMP8_MAXIMUM);
		scanf("%d",&parm2);
		if (parm2!=(-1) && (parm2<COMP8_MINIMUM || parm2>COMP8_MAXIMUM))
			{ printf("Input out of range.\n");return FALSE;}
		printf("SAM blocksize: %d. SP_OFF, %d. SP_USER  [-1 = no change]\n",
		     SP_OFF,SP_USER);
		scanf("%d",&parm3);
		if (parm3!=(-1) && (parm3!=SP_OFF && parm3!=SP_USER))
			{ printf("Input out of range.\n");return FALSE;}
	
		
		ctrlMessage->flag = PANO_CONFIG_COMPRESS2;
		ctrlMessage->params[PANO_CONFIG_CMP_EDGE%10] = parm0;
		ctrlMessage->params[PANO_CONFIG_CMP_CONTRAST%10] = parm1;
		ctrlMessage->params[PANO_CONFIG_CMP_FOCUSWGHT%10] = parm2;
		ctrlMessage->params[PANO_CONFIG_CMP_BLOCKSIZE%10] = parm3;
		break;
	case PANO_CONFIG_COMPFOCUS:
		printf("Fill a focus box... [-1 for any value clears list, 16x16minimum]\nLeft:");
		fflush(stdout);
		scanf("%d",&parm0);
		if (parm0<(-1) || parm0>1024)
			{ printf("Input out of range.\n");return FALSE;}
		printf("Top:");fflush(stdout);
		scanf("%d",&parm1);
		if (parm1<(-1) || parm1>1024)
			{ printf("Input out of range.\n");return FALSE;}
		printf("Right:");fflush(stdout);
		scanf("%d",&parm2);
		if (parm2<(-1) || parm2>1024)
			{ printf("Input out of range.\n");return FALSE;}
		printf("Bottom:");fflush(stdout);
		scanf("%d",&parm3);
		if (parm3<(-1) || parm3>1024)
			{ printf("Input out of range.\n");return FALSE;}
		if (abs(parm0-parm2)<16 || abs(parm1-parm3)<16)
			{ printf("Box must be at least 16 x 16.\n");return FALSE;}
		ctrlMessage->flag = PANO_CONFIG_COMPFOCUS;
		ctrlMessage->params[PANO_CONFIG_BOXLEFT] = parm0;
		ctrlMessage->params[PANO_CONFIG_BOXTOP] = parm1;
		ctrlMessage->params[PANO_CONFIG_BOXRIGHT] = parm2;
		ctrlMessage->params[PANO_CONFIG_BOXBOTTOM] = parm3;
		break;
	
	case PANO_CONFIG_COMPSAM:
		printf("Fill a SAM block... [-1 for all values will clear list]\nLeft:");
		fflush(stdout);
		scanf("%d",&parm0);
		if (parm0<(-1) || parm0>1024)
			{ printf("Input out of range.\n");return FALSE;}
		printf("Top:");fflush(stdout);
		scanf("%d",&parm1);
		if (parm1<(-1) || parm1>1024)
			{ printf("Input out of range.\n");return FALSE;}
		printf("Right:");fflush(stdout);
		scanf("%d",&parm2);
		if (parm2<(-1) || parm2>1024)
			{ printf("Input out of range.\n");return FALSE;}
		printf("Bottom:");fflush(stdout);
		scanf("%d",&parm3);
		if (parm3<(-1) || parm3>1024)
			{ printf("Input out of range.\n");return FALSE;}
		if (abs(parm0-parm2)<16 || abs(parm1-parm3)<16)
			{ printf("Box must be at least 16 x 16.\n");return FALSE;}
		ctrlMessage->flag = PANO_CONFIG_COMPSAM;
		ctrlMessage->params[PANO_CONFIG_BOXLEFT] = parm0;
		ctrlMessage->params[PANO_CONFIG_BOXTOP] = parm1;
		ctrlMessage->params[PANO_CONFIG_BOXRIGHT] = parm2;
		ctrlMessage->params[PANO_CONFIG_BOXBOTTOM] = parm3;
		break;
	case PANO_CONFIG_EXPOSURE:
		printf("New exposure setting: between %d and %d. [0 means no change]\n",EXPOSURE_MINIMUM,EXPOSURE_MAXIMUM);
		scanf("%d",&parm0);
		if (parm0!=0 && (parm0<EXPOSURE_MINIMUM || parm0>EXPOSURE_MAXIMUM))
			{ printf("Input out of range.\n");return FALSE;}
		printf("New minimum adjustment setting: between %d and %d. [0 means no change]\n",
			ADJUSTMENT_MINIMUM, ADJUSTMENT_MAXIMUM);
		scanf("%d",&parm1);
		if (parm1!=0 && (parm1<ADJUSTMENT_MINIMUM || parm1>ADJUSTMENT_MAXIMUM))
			{ printf("Input out of range.\n");return FALSE;}
		printf("Percent of pixels which can be saturated: between %d and %d. [0 means no change]\n",
			SATURATION_MINIMUM,SATURATION_MAXIMUM);
		scanf("%d",&parm2);
		if (parm2!=0 && (parm2<SATURATION_MINIMUM || parm2>SATURATION_MAXIMUM))
			{ printf("Input out of range.\n");return FALSE;}
		printf("Average value of pixels to target: between %d and %d. [0 means no change]\n",
			AVGPIXEL_MINIMUM,AVGPIXEL_MAXIMUM);
		scanf("%d",&parm3);
		if (parm3!=0 && (parm3<AVGPIXEL_MINIMUM || parm3>AVGPIXEL_MAXIMUM))
			{ printf("Input out of range.\n");return FALSE;}

		ctrlMessage->flag = PANO_CONFIG_EXPOSURE;
		ctrlMessage->params[PANO_CONFIG_EX_SETTING%10] = parm0;
		ctrlMessage->params[PANO_CONFIG_EX_ADJUST%10] = parm1;
		ctrlMessage->params[PANO_CONFIG_EX_SATURATION%10] = parm2;
		ctrlMessage->params[PANO_CONFIG_EX_AVGPIXEL%10] = parm3;
		break;
	case PANO_CONFIG_OLDCOLOR:
		printf("%d. Use combined color format. or %d. Use separated RGB format.\n",
			PANO_CONFIG_OC_ACTIVE%10,PANO_CONFIG_OC_INACTIVE%10);
		scanf("%d",&parm0);
		if (parm0!=PANO_CONFIG_OC_ACTIVE%10 && parm0!=PANO_CONFIG_OC_INACTIVE%10)
			{printf("Input out of range.\n");return FALSE;}
		ctrlMessage->flag = PANO_CONFIG_OLDCOLOR;
		ctrlMessage->params[0]=parm0;
		break;
	case 999:
		return FALSE;
	default:
		printf("Unknown configuration option.\n");
		return FALSE;
	}
	return TRUE;
}

int SnapshotPrint()
{
	int input=0;
	while(!input) 
	{
		printf("    You have reached the snapshot menu. Please choose a number.\n");
		printf("      %d. Send a full raw image: 1024 x 1024 x 12bits(2bytes).\n",PANO_SNAPSHOT_RAW);
		printf("      %d. Send three full R-G-B images: 512 x 512 x 12bits(2bytes).\n",PANO_SNAPSHOT_RGB);
		printf("      %d. Send a full combined RGB image: 512 x 512 x 24bits(3bytes).\n",PANO_SNAPSHOT_RGBOLD);
		printf("      %d. Send a compressed RGB image: 512 x 512 wavelet file.\n",PANO_SNAPSHOT_COMPOLD);
		printf("      %d. Send three compressed R-G-B images: ? x ? wavelet file.\n",PANO_SNAPSHOT_COMPRGB);
		printf("      %d. Return to the main menu.\n",999);
		fflush(stdin);
		scanf("%d",&input);
		if (input<1 || input>1000)
		{
			printf("Sorry, invalid entry. Once more...\n   ");
			input=0;
		}
	}
	return input;
}

boolean ParseSnapshot(int input, panoReceive ctrlMessage)
{
	switch(input)
	{
	case PANO_SNAPSHOT_RAW:
		ctrlMessage->flag=PANO_SNAPSHOT_RAW;
		break;
	case PANO_SNAPSHOT_RGB:
		ctrlMessage->flag=PANO_SNAPSHOT_RGB;
		break;
	case PANO_SNAPSHOT_RGBOLD:
		ctrlMessage->flag=PANO_SNAPSHOT_RGBOLD;
		break;
	case PANO_SNAPSHOT_COMPRGB:
		ctrlMessage->flag=PANO_SNAPSHOT_COMPRGB;
		break;
	case PANO_SNAPSHOT_COMPOLD:
		ctrlMessage->flag=PANO_SNAPSHOT_COMPOLD;
		break;
	case 999:
		return FALSE;
	default:
		printf("Unknown configuration option.\n");
		return FALSE;
	}
	return TRUE;
}