/* ===========================================================
    swi32.c
    Import Library for swi32.dll

    Created:  February 10, 1996
    Revised:  March 3, 1997

    Copyright (c) 1996-1997 Summus, Ltd. All rights reserved.
============================================================== */

#include "swi32.h"

#define DLLNAME "swi32.dll"
/* #define DLLNAME "swid32.dll" */

#define CheckWiDLL if(!WIHlib)WIHlib=LoadLibrary(DLLNAME);

typedef WiRawImage*  (CALLSPEC *WiProc01)(void);
typedef WiCmpImage* (CALLSPEC *WiProc02)(void);
typedef WiCmpOptions* (CALLSPEC *WiProc03)(void);
typedef WiDecmpOptions* (CALLSPEC *WiProc04)(void);
typedef void (CALLSPEC *WiProc05)(WiRawImage*);
typedef void (CALLSPEC *WiProc06)(WiCmpImage*);
typedef void (CALLSPEC *WiProc07)(WiCmpOptions*);
typedef void (CALLSPEC *WiProc08)(WiDecmpOptions*);
typedef int  (CALLSPEC *WiProc09)(WiCmpOptions*, WiRawImage*, WiCmpImage*);
typedef int  (CALLSPEC *WiProc10)(WiDecmpOptions*, WiRawImage*, WiCmpImage*);
typedef int  (CALLSPEC *WiProc11)(WiRawImage*);
typedef void (CALLSPEC *WiProc12)(WiRawImage*);
typedef void (CALLSPEC *WiProc13)(WiCmpImage*);

typedef int (CALLSPEC *WiProc14)(SiImageInfo*,SiCmpOption*,SiCmpDataInfo*);
typedef int (CALLSPEC *WiProc15)(SiCmpDataInfo*,SiDecmpOption*,SiImageInfo*);
typedef int (CALLSPEC *WiProc16)(SiImageInfo*);
typedef void (CALLSPEC *WiProc17)(SiImageInfo*);
typedef void (CALLSPEC *WiProc18)(SiCmpDataInfo*);

typedef int  (CALLSPEC *WiProc20)(WiDecmpOptions*, WiRawImage*, WiCmpImage*);
typedef int  (CALLSPEC *WiProc21)(WiDecmpOptions*, WiRawImage*, WiCmpImage*);
typedef int  (CALLSPEC *WiProc22)(WiDecmpOptions*, WiRawImage*, WiCmpImage*);
typedef void  (CALLSPEC *WiProc23)(WiDecmpOptions*, WiRawImage*, WiCmpImage*);

static HINSTANCE WIHlib = NULL;



WiRawImage* CALLSPEC WiCreateRawImage()
{
    WiProc01 proc;

    CheckWiDLL
    proc = (WiProc01)GetProcAddress(WIHlib, "WiCreateRawImage");
    return (*proc)();
}

WiCmpImage* CALLSPEC WiCreateCmpImage()
{
    WiProc02 proc;

    CheckWiDLL
    proc = (WiProc02)GetProcAddress(WIHlib, "WiCreateCmpImage");
    return (*proc)();
}

WiCmpOptions* CALLSPEC WiCreateCmpOptions()
{
    WiProc03 proc;
    CheckWiDLL
    proc = (WiProc03)GetProcAddress(WIHlib, "WiCreateCmpOptions");
    return (*proc)();
}

WiDecmpOptions* CALLSPEC WiCreateDecmpOptions()
{
    WiProc04 proc;

    CheckWiDLL
    proc = (WiProc04)GetProcAddress(WIHlib, "WiCreateDecmpOptions");
    return (*proc)();
}

void CALLSPEC WiDestroyRawImage(WiRawImage *rawimage)
{
    WiProc05 proc;

    CheckWiDLL
    proc = (WiProc05)GetProcAddress(WIHlib, "WiDestroyRawImage");
    (*proc)(rawimage);
}

void CALLSPEC WiDestroyCmpImage(WiCmpImage *cmpimage)
{
    WiProc06 proc;

    CheckWiDLL
    proc = (WiProc06)GetProcAddress(WIHlib, "WiDestroyCmpImage");
    (*proc)(cmpimage);
}

void CALLSPEC WiDestroyCmpOptions(WiCmpOptions *options)
{
    WiProc07 proc;

    CheckWiDLL
    proc = (WiProc07)GetProcAddress(WIHlib, "WiDestroyCmpOptions");
    (*proc)(options);
}

void CALLSPEC WiDestroyDecmpOptions(WiDecmpOptions *options)
{
    WiProc08 proc;

    CheckWiDLL
    proc = (WiProc08)GetProcAddress(WIHlib, "WiDestroyDecmpOptions");
    (*proc)(options);
}

int CALLSPEC WiCompress(
	WiCmpOptions *options,
	WiRawImage   *rawimage,
	WiCmpImage   *cmpimage)
{
    WiProc09 proc;

    CheckWiDLL
    proc = (WiProc09)GetProcAddress(WIHlib, "WiCompress");
    return (*proc)(options, rawimage, cmpimage);
}

int CALLSPEC WiDecompress(
	WiDecmpOptions *options,
	WiRawImage     *rawimage,
	WiCmpImage     *cmpimage)
{
    WiProc10 proc;

    CheckWiDLL
    proc = (WiProc10)GetProcAddress(WIHlib, "WiDecompress");
    return (*proc)(options, rawimage, cmpimage);
}

int CALLSPEC WiBeginDecompress(
	WiDecmpOptions *options,
	WiRawImage     *rawimage,
	WiCmpImage     *cmpimage)
{
    WiProc20 proc;

    CheckWiDLL
    proc = (WiProc20)GetProcAddress(WIHlib, "WiBeginDecompress");
    return (*proc)(options, rawimage, cmpimage);
}

void CALLSPEC WiEndDecompress(
	WiDecmpOptions *options,
	WiRawImage     *rawimage,
	WiCmpImage     *cmpimage)
{
    WiProc23 proc;

    CheckWiDLL
    proc = (WiProc23)GetProcAddress(WIHlib, "WiEndDecompress");
    (*proc)(options, rawimage, cmpimage);
}

int CALLSPEC WiDecompressSubHeader(
	WiDecmpOptions *options,
	WiRawImage     *rawimage,
	WiCmpImage     *cmpimage)
{
    WiProc22 proc;

    CheckWiDLL
    proc = (WiProc21)GetProcAddress(WIHlib, "WiDecompressSubHeader");
    return (*proc)(options, rawimage, cmpimage);
}

int CALLSPEC WiDecompressSubImage(
	WiDecmpOptions *options,
	WiRawImage     *rawimage,
	WiCmpImage     *cmpimage)
{
    WiProc21 proc;

    CheckWiDLL
    proc = (WiProc21)GetProcAddress(WIHlib, "WiDecompressSubImage");
    return (*proc)(options, rawimage, cmpimage);
}


int CALLSPEC WiGetProgressiveImage(
	WiRawImage     *rawimage)
{
    WiProc11 proc;

    CheckWiDLL
    proc = (WiProc11)GetProcAddress(WIHlib, "WiGetProgressiveImage");
    return (*proc)(rawimage);
}

void CALLSPEC WiFreeRawImageData(
        WiRawImage      *rawimage)
{
    WiProc12 proc;

    CheckWiDLL
    proc = (WiProc12)GetProcAddress(WIHlib, "WiFreeRawImageData");
    (*proc)(rawimage);
}

void CALLSPEC WiFreeCmpImageData(
        WiCmpImage      *cmpimage)
{
    WiProc13 proc;

    CheckWiDLL
    proc = (WiProc13)GetProcAddress(WIHlib, "WiFreeCmpImageData");
    (*proc)(cmpimage);
}

int CALLSPEC SiCompress(
	SiImageInfo *rawimage,
	SiCmpOption *options,
	SiCmpDataInfo *cmpimage )
{
    WiProc14 proc;

    CheckWiDLL
    proc = (WiProc14)GetProcAddress(WIHlib, "SiCompress");
    return (*proc)(rawimage, options, cmpimage);
}

int CALLSPEC SiDecompress(
	SiCmpDataInfo *cmpimage,
	SiDecmpOption *options,
	SiImageInfo *rawimage )
{
    WiProc15 proc;

    CheckWiDLL
    proc = (WiProc15)GetProcAddress(WIHlib, "SiDecompress");
    return (*proc)(cmpimage, options, rawimage);
}

int CALLSPEC SiGetImageInfo(
	SiImageInfo *rawimage )
{
    WiProc16 proc;

    CheckWiDLL
    proc = (WiProc16)GetProcAddress(WIHlib, "SiGetImageInfo");
    return (*proc)(rawimage);
}

void CALLSPEC SiFreeImageInfo(
	SiImageInfo *rawimage )
{
    WiProc17 proc;

    CheckWiDLL
    proc = (WiProc17)GetProcAddress(WIHlib, "SiFreeImageInfo");
    (*proc)(rawimage);
}


void CALLSPEC SiFreeCmpDataInfo(
	SiCmpDataInfo *cmpimage )
{
    WiProc18 proc;

    CheckWiDLL
    proc = (WiProc18)GetProcAddress(WIHlib, "SiFreeCmpDataInfo");
    (*proc)(cmpimage);
}


/* end of swi32.c */

