#include "includes.h"

// -----------------------------------------
BFBOOL PrepareGlobals();
void FreeGlobals();

// -----------------------------------------
HANDLE hAcqColorThread;
HANDLE AcqColorEvent[10];
HANDLE hComp0Thread;
HANDLE hComp1Thread;
HANDLE Comp0Event[10];
HANDLE Comp1Event[10];
HANDLE hNddsSendThread;
HANDLE NddsSendEvent[10];

PBFU16 RawImageBlk = NULL;
PBFU16 RawImageBuf = NULL;
PBFU8  RGBOldBufs[2] = {NULL,NULL};
PBFU8  RGBOldBlks[2] = {NULL,NULL};
PBFU8 RGBImageBufs[6] = {NULL,NULL,NULL,NULL,NULL,NULL};
PBFU8 RGBImageBlks[6] = {NULL,NULL,NULL,NULL,NULL,NULL};
PBFU8 CmpImageBufs[6] = {NULL,NULL,NULL,NULL,NULL,NULL};
PBFU8 CmpImageBlks[6] = {NULL,NULL,NULL,NULL,NULL,NULL};
PBFU8  CmpOldBufs[2] = {NULL,NULL};
PBFU8  CmpOldBlks[2] = {NULL,NULL};

WiCmpOptions  *cmpOpts;
WiRawImage *rawImage, *rawOld;
WiCmpImage *WiOldBufs[2];
WiCmpImage *WiImageBufs[6];
WiBox *regionMap;    /* Area containing region block coordinates */
WiBox *focusBoxes;   /* Area containing focus boxes coordinates */

BFBOOL OldRGBColor;
int RdRnExposure;
int avgpixelThresh;
double saturationThresh;
int adjustAmount;
BFBOOL PanoRun;
BFBOOL PanoExit;
long LastTimestamp[2][2];
int PanoCamIs;
int AcqWait;
int PanoImageNumPkts;

int ndds_send_bps;
int ndds_send_msecdelay;
// --------------------------------------------
BFBOOL PrepareGlobals()
{
	int i;
	PanoCamIs=PANO_CAMSWITCH_PANO;
	RdRnExposure=0x10;
	OldRGBColor = TRUE;
	avgpixelThresh =1500;
	saturationThresh = 0.10;
	adjustAmount = 0x1;
	PanoRun=FALSE;
	PanoExit=FALSE;
	ndds_send_bps = 700000;
	ndds_send_msecdelay = 70;
	AcqWait = 0;
	PanoImageNumPkts=1;
	srand( (unsigned)time( NULL ) );

	if (RawImageBlk == NULL)
	{
		RawImageBlk = (PBFU16) malloc(RAWIMSIZE+0x1000);
		RawImageBuf = (PBFU16) (((BFU32)RawImageBlk + 0x1000) & 0xfffff000);

		if (RawImageBlk == NULL || RawImageBuf == NULL)
		{
			printf ("Couldn't malloc RawImage buffer.\n");
			return FALSE;
		}
	}

	for (i=0;i<6;i++)
	{
		if (CmpImageBlks[i] == NULL)
		{
			CmpImageBlks[i] = (PBFU8) malloc(RAWIMSIZE+0x1000);
			CmpImageBufs[i] = (PBFU8) (((BFU32)CmpImageBlks[i] + 0x1000) & 0xfffff000);

			if (CmpImageBlks[i] == NULL || CmpImageBufs[i] == NULL)
			{
				printf ("Couldn't malloc CmpImageBuf %d.\n",i);
				return FALSE;
			}
		}
	}
	
	for (i=0;i<6;i++)
	{
		if (RGBImageBlks[i] == NULL)
		{
			RGBImageBlks[i] = (PBFU8) malloc(RGBIMWIDTH*RGBIMWIDTH*2+0x1000);
			RGBImageBufs[i] = (PBFU8) (((BFU32)RGBImageBlks[i] + 0x1000) & 0xfffff000);

			if (RGBImageBlks[i] == NULL || RGBImageBufs[i] == NULL)
			{
				printf ("Couldn't malloc RGBImageBuf %d.\n",i);
				return FALSE;
			}
		}
	}
	
	
	for (i=0;i<2;i++)
	{
		if (CmpOldBlks[i] == NULL)
		{
			CmpOldBlks[i] = (PBFU8) malloc(RAWIMSIZE+0x1000);
			CmpOldBufs[i] = (PBFU8) (((BFU32)CmpOldBlks[i] + 0x1000) & 0xfffff000);

			if (CmpOldBlks[i] == NULL || CmpOldBufs[i] == NULL)
			{
				printf ("Couldn't malloc CmpOldBuf %d.\n",i);
				return FALSE;
			}
		}
	}
	for (i=0;i<2;i++)
	{
		if (RGBOldBlks[i] == NULL)
		{
			RGBOldBlks[i] = (PBFU8) malloc(RGBIMSIZE+0x1000);
			RGBOldBufs[i] = (PBFU8) (((BFU32)RGBOldBlks[i] + 0x1000) & 0xfffff000);

			if (RGBOldBlks[i] == NULL || RGBOldBufs[i] == NULL)
			{
				printf ("Couldn't malloc RGBOldBuf %d.\n",i);
				return FALSE;
			}
		}
	}
	return TRUE;
}

void FreeGlobals()
{
	int i;
	Sleep(3000);
	if (RawImageBlk) free(RawImageBlk);

	WiDestroyCmpOptions(cmpOpts);
	WiDestroyRawImage(rawImage);
	WiDestroyRawImage(rawOld);
	WiDestroyCmpImage(WiOldBufs[0]);
	WiDestroyCmpImage(WiOldBufs[1]);
	for (i=0;i<6;i++) WiDestroyCmpImage(WiImageBufs[i]);

	for (i=0;i<6;i++)
	{
		if (CmpImageBlks[i] == NULL) free(CmpImageBlks[i]);
		if (RGBImageBlks[i] == NULL) free(RGBImageBlks[i]);
	}

	for (i=0;i<2;i++)
	{
		if (CmpOldBlks[i] == NULL) free(CmpOldBlks[i]);
		if (RGBOldBlks[i] == NULL) free(RGBOldBlks[i]);
	}
	return;
}


