/* Asyncronous message FIFO */

#ifdef __cplusplus
extern "C" {
#endif
/* message queue typedefs */
typedef struct _fifo *FIFO_ID;	/* message queue ID */

extern int 	FifoLibInit (void);
extern FIFO_ID FifoCreate (int maxMsgs, int maxMsgLength);
extern int 	FifoDelete (FIFO_ID FifoId);
extern int 	FifoSend (FIFO_ID FifoId, char *buffer, unsigned int nBytes);
extern int 	FifoReceive (FIFO_ID FifoId, char *buffer,
			     unsigned int maxNBytes);
/* Get the size and pointer to the top message without removing it */
extern int 	FifoPeek (FIFO_ID m, char **ptr);
extern int 	FifoNumMsgs (FIFO_ID FifoId);

#ifndef OK
#define OK	0
#undef ERROR
#define ERROR	(-1)
#endif

#ifndef NULL
#define NULL	((void *)0)
#endif

#ifdef __cplusplus
}
#endif

