#include "globals.h"
#include "fifo.h"
#include <NDDS.h>
#include "panoText.h"
#include <math.h>
// --------------------------
extern void StopTimer ();
void InitNddsSendThread();
void NddsSendThread();
void EndNddsSendThread();
extern void SendBuf (u_char *buf, int length, int typeflag, long *timestamp);
extern int  FifoDelete (FIFO_ID FifoId);
void PanoError(int flag, char *message);
void PanoReport();
// --------------------------
extern FIFO_ID sendQueue;
int timestampnum;
panoText panoTextBuf;
NDDSProducer panoTextProducer;
// --------------------------

void InitNddsSendThread()
{
	DWORD NddsSendThreadId;
	printf("Initializing NddsSendThread.\n");
	
	hNddsSendThread = CreateThread( 
        NULL,						// no security attributes        
        0,							// use default stack size        
        (LPTHREAD_START_ROUTINE) NddsSendThread, // thread function       
        NULL,						// argument to thread function   
        0,							// use default creation flags    
        &NddsSendThreadId);			// returns the thread identifier 
	return;
}

void NddsSendThread()
{
	DWORD evnt;
	BFU32 imageType =PANO_TYPEFLAG_CMPGREEN;
	int timetstampnum =1;
	printf("Starting NddsSendThread.\n");
	// create the events
	NddsSendEvent[NDDSSEND_END]=CreateEvent(NULL,FALSE, FALSE,"ExitNddsSendThread");
	NddsSendEvent[NDDSSEND_COMP0RED]=CreateEvent(NULL,FALSE,FALSE,"NddsSendComp0Red");
	NddsSendEvent[NDDSSEND_COMP0GREEN]=CreateEvent(NULL,FALSE,FALSE,"NddsSendComp0Green");
	NddsSendEvent[NDDSSEND_COMP0BLUE]=CreateEvent(NULL,FALSE,FALSE,"NddsSendComp0Blue");
	NddsSendEvent[NDDSSEND_COMP1RED]=CreateEvent(NULL,FALSE,FALSE,"NddsSendComp1Red");
	NddsSendEvent[NDDSSEND_COMP1GREEN]=CreateEvent(NULL,FALSE,FALSE,"NddsSendComp1Green");
	NddsSendEvent[NDDSSEND_COMP1BLUE]=CreateEvent(NULL,FALSE,FALSE,"NddsSendComp1Blue");
	NddsSendEvent[NDDSSEND_COMP0OLD]=CreateEvent(NULL,FALSE,FALSE,"NddsSendComp0Old");
	NddsSendEvent[NDDSSEND_COMP1OLD]=CreateEvent(NULL,FALSE,FALSE,"NddsSendComp1Old");
	NddsSendEvent[NDDSSEND_RAWIMAGE]=CreateEvent(NULL,FALSE,FALSE,"NddsSendRawImage");
	NddsSendEvent[NDDSSEND_RGBIMAGE]=CreateEvent(NULL,FALSE,FALSE,"NddsSenndRGBImage");

	//begin the main loop waiting for buffers to send
	while (1)
	{
		evnt=WaitForMultipleObjects(11,NddsSendEvent, FALSE, INFINITE)-WAIT_OBJECT_0;
		switch (evnt)
		{
		case NDDSSEND_END:
			return;
		case NDDSSEND_RAWIMAGE:
			SendBuf((unsigned char*)RawImageBuf,RAWIMSIZE,PANO_TYPEFLAG_RAW,LastTimestamp[0]);
			break;
		case NDDSSEND_RGBIMAGE:
			if (PanoExit==TRUE)
			{
				printf("In RGBSEND??? taking quick exit.\n");return;
			}
			
			if (OldRGBColor)
				SendBuf(RGBOldBufs[0],RGBIMSIZE,PANO_TYPEFLAG_RGB,LastTimestamp[0]);
			else
			{
				SendBuf(RGBImageBufs[0],RGBIMWIDTH*RGBIMWIDTH*2,PANO_TYPEFLAG_RED,LastTimestamp[0]);
				SendBuf(RGBImageBufs[1],RGBIMWIDTH*RGBIMWIDTH*2,PANO_TYPEFLAG_GREEN,LastTimestamp[0]);
				SendBuf(RGBImageBufs[2],RGBIMWIDTH*RGBIMWIDTH*2,PANO_TYPEFLAG_BLUE,LastTimestamp[0]);
			}
			break;
		case NDDSSEND_COMP0RED:
			timestampnum=0;
			imageType=PANO_TYPEFLAG_CMPRED;
			goto CompSend;
		case NDDSSEND_COMP0GREEN:
			timestampnum=0;
			goto CompSend;
		case NDDSSEND_COMP0BLUE:
			timestampnum=0;
		case NDDSSEND_COMP1BLUE:
			imageType=PANO_TYPEFLAG_CMPBLUE;
			goto CompSend;
		case NDDSSEND_COMP1RED:
			imageType=PANO_TYPEFLAG_CMPRED;
		case NDDSSEND_COMP1GREEN:
CompSend:	if (WiImageBufs[evnt-NDDSSEND_COMP0RED]->Size==0) printf("CmpImage had size 0.\n");
			else 
			{
				//printf("Sending buffer %d, of %d\n",evnt-NDDSSEND_COMP0RED,
				//	WiImageBufs[evnt-NDDSSEND_COMP0RED]->Size);
				SendBuf(WiImageBufs[evnt-NDDSSEND_COMP0RED]->CmpData,
							WiImageBufs[evnt-NDDSSEND_COMP0RED]->Size,
							imageType,LastTimestamp[timestampnum]);
			}
			break;
		// these are the old true rgb buffers, being replaced with the above 12bit colors.
		case NDDSSEND_COMP0OLD:
			timestampnum=0;
		case NDDSSEND_COMP1OLD:
	//		printf("Sending CompBuf.\n");
			if (WiOldBufs[evnt-NDDSSEND_COMP0OLD]->Size==0) PanoError(PE_ERROR,"CmpImage had size 0");
			else 
			{
				//	printf("Sending buffer %d, of %d.\n",evnt-NDDSSEND_COMP0OLD,
			//		WiOldBufs[evnt-NDDSSEND_COMP0OLD]->Size);
				SendBuf(WiOldBufs[evnt-NDDSSEND_COMP0OLD]->CmpData,
							WiOldBufs[evnt-NDDSSEND_COMP0OLD]->Size,
							PANO_TYPEFLAG_IMAGE,LastTimestamp[timestampnum]);
			}
			break;
		default:
			printf("In nonevent case:%d.\n",evnt-WAIT_OBJECT_0);
			break;
		}		
	}
	return;
}

void EndNddsSendThread()
{
	DWORD returnValue;

	Sleep(2000);
	
	SetEvent(NddsSendEvent[NDDSSEND_END]);
	returnValue = WaitForSingleObject(hNddsSendThread,2000)-WAIT_OBJECT_0;
	if (returnValue)
	{
		printf ("Wait for thread to complete failed:%d.\n",returnValue-WAIT_OBJECT_0);
	}

	printf("NddsSendThread ended.\n");

	//Do some close down work here at the end.
	Sleep(2000);
	StopTimer();
	FifoDelete(sendQueue);
	sendQueue=NULL;
	return;
}

void PreparePanoText()
{
    /* Register types */
	panoTextNddsRegister();
	
    /* Allocate space for NDDS types */
    panoTextBuf = panoTextAllocate ( (const char *)NULL,
				(const char *)NULL, (void *)2048);
    /* Allocate producers and consumers */
    panoTextProducer = NddsProducerCreate (PANO_NAME, NDDS_SYNCHRONOUS, 15.0f, 1.0f);
    /* Setup messages to send out */
    NddsProducerProductionAdd (panoTextProducer, PANO_TEXT_NAME, PANO_TEXT_NAME, panoTextBuf, 
			       0, NULL, NULL, NULL, NULL);

    Sleep(1000);	/* Give up CPU, so NDDS can setup */
	return;
}

void PanoError(int flag, char *message)
{
	char *error;
	struct _timeb tstruct; 
	char *timeline;
	long tmptime[2];

	error=(char*)malloc(2048);
	_ftime( &tstruct );
    timeline = ctime( & (tmptime[0]=tstruct.time) );
	tmptime[1]=tstruct.millitm;
	sprintf(error,"PANO-%s:%s           %s\n",
		(flag==PE_ERROR)?"error":(flag==PE_LOG)?"log":"handshake",timeline,message);
	panoTextBuf->type=flag;
	strcpy(panoTextBuf->data,error);
	NddsProducerSample(panoTextProducer);
	free(error);

	return;
}

void PanoReport()
{
	int i;
	char * report;
	char tmp[20];
	struct _timeb tstruct; 
	char *timeline;
	long tmptime[2];

	report=(char*)malloc(4096);
	_ftime( &tstruct );
    timeline = ctime( & (tmptime[0]=tstruct.time) );
	switch (cmpOpts->Encoder)
	{
	case E_SLOW: strcpy(tmp,"Slow");break;
	case E_NORMAL:strcpy(tmp,"Normal");break;
	case E_FAST:strcpy(tmp,"Fast");break;
	case E_FASTEST: strcpy(tmp,"Fastest");break;
	}
	sprintf(report,"PanosphericReport:%.19s.%hu %s", timeline, tmptime[1]=tstruct.millitm, &timeline[20] );
	sprintf(report+strlen(report),"   %s camera %s. Color: %s. Delay:%dms, bps:%d\n",
		PanoCamIs==PANO_CAMSWITCH_PANO?"Panospheric":"BackView", PanoRun?"Running":"Stopped",
		OldRGBColor?"Combined RGB":"Separate R-G-B", ndds_send_msecdelay,ndds_send_bps);
	sprintf(report+strlen(report),"   Exposure:%d, Minimum Adjust:%d, SatThresh:%d%%, AvgPixelValue:%d.\n",
		RdRnExposure,adjustAmount,(int)(saturationThresh*100),avgpixelThresh);
	if (cmpOpts!=NULL)
	{
		sprintf(report+strlen(report),"   %s Compression at %d",
			(cmpOpts->CmpControl==CR_QUALITY)?"Quality":"Ratio",
			(cmpOpts->CmpControl==CR_QUALITY)?1+(int)(cmpOpts->Quality*100):(int)cmpOpts->CmpRatio);
		sprintf(report+strlen(report),"%s using Path%d on %s encoder.\n",
			(cmpOpts->CmpControl==CR_QUALITY)?"%":":1",
			cmpOpts->EncodePath+1,
			tmp);
		sprintf(report+strlen(report),"      EdgeEnhance:%d, ContrastEnhance:%d, FocusWeight:%d, BlockSize:%s\n",
			cmpOpts->EdgeEnhancement,cmpOpts->ContrastEnhancement,cmpOpts->FocusWeight,
			cmpOpts->BlockSize==SP_OFF?"SP_OFF":cmpOpts->BlockSize==SP_USER?"SP_USER":"Other");
		if (cmpOpts->nBoxes>0)
		{
			sprintf(report+strlen(report),"FocusBoxes:%d\n",cmpOpts->nBoxes);
			for (i=0;i<cmpOpts->nBoxes;i++)
				sprintf(report+strlen(report),"Left:%-4.3d Top:%-4.3d Right:%-4.3d Bottom:%-4.3d\n",
				cmpOpts->FocusBoxes[i].Left,cmpOpts->FocusBoxes[i].Top,
				cmpOpts->FocusBoxes[i].Right,cmpOpts->FocusBoxes[i].Bottom);
		}
		if (cmpOpts->nBlocks>0)
		{
			sprintf(report+strlen(report),"\nRegions:%d\n",cmpOpts->nBlocks);
			for (i=0;i<cmpOpts->nBlocks;i++)
				sprintf(report+strlen(report),"Left:%.4d Top:%.4d Right:%.4d Bottom:%.4d\n",
				cmpOpts->Blocks[i].Left,cmpOpts->Blocks[i].Top,
				cmpOpts->Blocks[i].Right,cmpOpts->Blocks[i].Bottom);
		}
	}
	else sprintf(report+strlen(report),"      Compression structure was null.. no information.\n");
	panoTextBuf->type=PE_HANDSHAKE;
	strcpy(panoTextBuf->data,report);
  	NddsProducerSample(panoTextProducer);
	free(report);
	return;
}
