#include "globals.h"
#include "NDDS.h"
#include "panoReceive.h"

// --------------------------
void Initialize();
void ControlLoop();
void Shutdown();
void PrepareNddsReceive();
NDDSObjectInstance panoReceiveCallback(NDDSUpdateInfo update);

extern BFBOOL PrepareGlobals();
extern void FreeGlobals();

extern void PrepareAcqColor();
extern void InitAcqColorThread();
extern void AcqColorThread();
extern void EndAcqColorThread();
extern void StartStreamAcq();
extern void StopStreamAcq();
extern void Colorize(int bufnum);

extern void PrepareComp();
extern void InitComp0Thread();
extern void InitComp1Thread();
extern void Comp0Thread();
extern void Comp1Thread();
extern void EndComp0Thread();
extern void EndComp1Thread();
extern void FillTimestamp0();
extern void RAtoBox(int *a, WiBox *b);


extern void PrepareNddsSend();
extern void PreparePanoText();
extern void InitNddsSendThread();
extern void NddsSendThread();
extern void EndNddsSendThread();
extern void PanoReport();
extern void PanoError(int flag, char *message);
extern void QuickImageGrab();

// --------------------------
NDDSConsumer panoReceiveConsumer;
panoReceiveStruct p_panoReceive;
int main (int argc, char *argv[])
{
	Initialize();
	ControlLoop();
	Shutdown();
	return 1;
}

void Initialize()
{
	//perform any prepatory work that the threads need.
	PrepareGlobals();
	PrepareNddsSend();
	PreparePanoText();
	PrepareNddsReceive();
	PrepareAcqColor();
	PrepareComp();
	//turn on the threads.
	InitNddsSendThread();
	InitComp0Thread();
	InitComp1Thread();
	InitAcqColorThread();

	//wait to allow threads to set themselves up.
	Sleep(1000);
	return;
}

void ControlLoop()
{
	int i=0;

	//This is the main control loop.

	while (1)
	{
		NddsConsumerPoll(panoReceiveConsumer);
		if (PanoExit==TRUE) break;
		Sleep(1000);
	}
	PanoError(PE_LOG,"program terminating");
	return;
}

void PrepareNddsReceive()
//This is based on the nddsgen consumer code snippets.
{
	panoReceiveNddsRegister();
	panoReceiveConsumer = NddsConsumerCreate(PANO_NAME, NDDS_POLLED, 1000.0f, 1.0f);
	NddsConsumerSubscriptionAdd(panoReceiveConsumer,PANO_RECEIVE_NAME,
		PANO_RECEIVE_NAME, (NDDSObjectInstance) &p_panoReceive,panoReceiveCallback,NULL);
	return;
}

NDDSObjectInstance panoReceiveCallback(NDDSUpdateInfo update)
{
	boolean tmp2=FALSE;
	int tmp=OldRGBColor;
	int tmpmine=0;
	if (update->updateStatus != NDDS_FRESH_DATA) {return NULL;}
	//We have new data from NDDS, so lets process it

	int message = p_panoReceive.message;
	switch (message)
	{
	case PANO_START:
		PanoError(PE_HANDSHAKE,"PANO_START received.");
		if (!PanoRun) StartStreamAcq();
		break;
	case PANO_STOP:
		PanoError(PE_HANDSHAKE,"PANO_STOP received.");
		if (PanoRun) StopStreamAcq();
		break;
	case PANO_REPORT:
		PanoReport();
		break;
	case PANO_CONFIG:
		PanoError(PE_HANDSHAKE,"PAN_CONFIG received.");
		if (PanoRun) { StopStreamAcq(); tmp2=TRUE;}
		
		switch (p_panoReceive.flag)
		{
		case PANO_CONFIG_NDDS:
			if (p_panoReceive.params[0]=0)
			{
				ndds_send_bps=p_panoReceive.params[0];
				ndds_send_msecdelay=0;
				tmpmine=1;
			}
			else
			{
				if ((-1)!=p_panoReceive.params[1])
				{
					ndds_send_msecdelay=p_panoReceive.params[1];
					tmpmine=1;
				}
			}
			if (tmpmine!=1) break;
			EndNddsSendThread();
			PrepareNddsSend();
			InitNddsSendThread();
			break;
		case PANO_CONFIG_COMPRESS1:
			if (p_panoReceive.params[PANO_CONFIG_CMP_QUALITY%10]!=0)
			{
				cmpOpts->Quality =(float)p_panoReceive.params[PANO_CONFIG_CMP_QUALITY%10]/100.f;
				cmpOpts->CmpRatio=(float)p_panoReceive.params[PANO_CONFIG_CMP_QUALITY%10];
			}
			if (p_panoReceive.params[PANO_CONFIG_CMP_CONTROL%10]!=(-1))
				cmpOpts->CmpControl =p_panoReceive.params[PANO_CONFIG_CMP_CONTROL%10];
			if (p_panoReceive.params[PANO_CONFIG_CMP_ENCODER%10]!=(-1))
				cmpOpts->Encoder =p_panoReceive.params[PANO_CONFIG_CMP_ENCODER%10];
			if (p_panoReceive.params[PANO_CONFIG_CMP_ENCPATH%10]!=(-2))
				cmpOpts->EncodePath =p_panoReceive.params[PANO_CONFIG_CMP_ENCPATH%10];
			break;
		case PANO_CONFIG_COMPRESS2:
			if (p_panoReceive.params[PANO_CONFIG_CMP_EDGE%10]!=(-1))
				cmpOpts->EdgeEnhancement =p_panoReceive.params[PANO_CONFIG_CMP_EDGE%10];
			if (p_panoReceive.params[PANO_CONFIG_CMP_CONTRAST%10]!=(-1))
				cmpOpts->ContrastEnhancement =p_panoReceive.params[PANO_CONFIG_CMP_CONTRAST%10];
			if (p_panoReceive.params[PANO_CONFIG_CMP_FOCUSWGHT%10]!=(-1))
				cmpOpts->FocusWeight =p_panoReceive.params[PANO_CONFIG_CMP_FOCUSWGHT%10];
			if (p_panoReceive.params[PANO_CONFIG_CMP_BLOCKSIZE%10]!=(-1))
				cmpOpts->BlockSize =p_panoReceive.params[PANO_CONFIG_CMP_BLOCKSIZE%10];
			break;
		case PANO_CONFIG_COMPFOCUS:
			if (p_panoReceive.params[0]==(-1) || p_panoReceive.params[1]==(-1) ||
				p_panoReceive.params[2]==(-1) || p_panoReceive.params[3]==(-1))
				cmpOpts->nBoxes=0;
			else 
			{
				if (cmpOpts->nBoxes<MAXCMP_FOCUS-1)
					RAtoBox(p_panoReceive.params,&cmpOpts->FocusBoxes[cmpOpts->nBoxes++]);
				else PanoError(PE_ERROR,"Already max number of Boxes");
			}
			break;
		case PANO_CONFIG_COMPSAM:
			if (p_panoReceive.params[0]==(-1) || p_panoReceive.params[1]==(-1) ||
				p_panoReceive.params[2]==(-1) || p_panoReceive.params[3]==(-1))
				cmpOpts->nBlocks=0;
			else 
			{
				if (cmpOpts->nBlocks<MAXCMP_BLOCKS-1)
					RAtoBox(p_panoReceive.params,&cmpOpts->Blocks[cmpOpts->nBlocks++]);
				else PanoError(PE_ERROR,"Already max number of Blocks");
			}
			break;
		case PANO_CONFIG_EXPOSURE:
			if (p_panoReceive.params[PANO_CONFIG_EX_SETTING%10]!=0)
				RdRnExposure=p_panoReceive.params[PANO_CONFIG_EX_SETTING%10];
			if (p_panoReceive.params[PANO_CONFIG_EX_ADJUST%10]!=0)
				adjustAmount=p_panoReceive.params[PANO_CONFIG_EX_ADJUST%10];
			if (p_panoReceive.params[PANO_CONFIG_EX_SATURATION%10]!=0)
				saturationThresh=(double)p_panoReceive.params[PANO_CONFIG_EX_SATURATION%10]/100;
			if (p_panoReceive.params[PANO_CONFIG_EX_AVGPIXEL%10]!=0)
				avgpixelThresh=p_panoReceive.params[PANO_CONFIG_EX_AVGPIXEL%10];
			SetEvent(AcqColorEvent[ACQCOLOR_EXPOSE]);
			break;
		case PANO_CONFIG_OLDCOLOR:
			if (p_panoReceive.params[0]=PANO_CONFIG_OC_ACTIVE)
				{ OldRGBColor=TRUE; break;}
			if (p_panoReceive.params[0]=PANO_CONFIG_OC_INACTIVE)
				{ OldRGBColor=FALSE; break;}
			break;
		default:
			PanoError(PE_ERROR,"Got unknown CONFIG message.");
			break;
		}
		break;
	case PANO_CAMSWITCH:
		PanoError(PE_HANDSHAKE,"CAMSWITCH received.");
		if (PanoRun) { StopStreamAcq(); tmp2=TRUE;}
		switch (p_panoReceive.flag)
		{
		case PANO_CAMSWITCH_PANO:
			PanoCamIs=PANO_CAMSWITCH_PANO;
			//This needs to be able to reconfigure the board to use the pano input
			break;
		case PANO_CAMSWITCH_BACK:
			PanoCamIs=PANO_CAMSWITCH_BACK;
			//This needs to be able to reconfigure the board to use the back input
			break;
		default:
			PanoError(PE_ERROR,"Got unknown CAMSWITCH message.");
			break;
		}
		break;
	case PANO_SNAPSHOT:
		PanoError(PE_HANDSHAKE,"SNAPSHOT received.");
		if (PanoRun) StopStreamAcq();
		QuickImageGrab();
		switch (p_panoReceive.flag)
		{
		case PANO_SNAPSHOT_RAW:
			FillTimestamp0();
			SetEvent(NddsSendEvent[NDDSSEND_RAWIMAGE]);
			Sleep(1000);
			break;
		case PANO_SNAPSHOT_RGB:
			OldRGBColor=FALSE;
			Colorize(0);
			FillTimestamp0();
			SetEvent(NddsSendEvent[NDDSSEND_RGBIMAGE]);
			Sleep(1000); 
			OldRGBColor=tmp;
			break;
		case PANO_SNAPSHOT_RGBOLD:
			OldRGBColor=TRUE;
			Colorize(0);
			FillTimestamp0();
			SetEvent(NddsSendEvent[NDDSSEND_RGBIMAGE]);
			Sleep(1000);
			OldRGBColor=tmp;
			break;
		case PANO_SNAPSHOT_COMPRGB:
			OldRGBColor=FALSE;
			Colorize(0);
			FillTimestamp0();
			SetEvent(Comp0Event[COMPRESS_GO]);
			Sleep(1000);
			OldRGBColor=tmp;
			break;	
		case PANO_SNAPSHOT_COMPOLD:
			OldRGBColor=TRUE;
			Colorize(0);
			FillTimestamp0();
			SetEvent(Comp0Event[COMPRESS_OLD]);
			Sleep(1000);
			OldRGBColor=tmp;
			break;
		default:
			PanoError(PE_ERROR,"Got unknown SNAPSHOT message.");
			break;
		}
		break;
	case PANO_HANDSHAKE: 
		PanoError(PE_HANDSHAKE,"HANDSHAKE received.");
		break;
	case PANO_EXIT:
		PanoError(PE_HANDSHAKE,"PANO_EXIT received.");
		PanoExit=TRUE;
		if (PanoRun) StopStreamAcq();
		break;
	default:
		PanoError(PE_HANDSHAKE,"UNKNOWN NDDS message.");
		break;
	}
	if (tmp2) StartStreamAcq();
	return update;
}


void Shutdown()
{
	ExitProcess(1);
	EndAcqColorThread();
	TerminateThread(hComp0Thread,1);
	TerminateThread(hComp1Thread,1);
	TerminateThread(hNddsSendThread,1);
	FreeGlobals();

	return;
}



