#include "globals.h"

// --------------------------
void PrepareComp();
void InitComp0Thread();
void InitComp1Thread();
void Comp0Thread();
void Comp1Thread();
void EndComp0Thread();
void EndComp1Thread();
void CompressImage(int bufnum);
void SaveCmpToFile(WiCmpImage *cmpImage);
void StreamCmpToFile(WiCmpImage *cmpImage);
void PanoError(int flag, char *message);

void SetCompressionOptions( WiCmpOptions *cmpOpts );
void SetCompressionRegion(WiCmpOptions *cmpOpts, WiBox regionMap[]);
void SetCompressionFocus(WiCmpOptions *cmpOpts, WiBox focusMap[]);
void CopyBox(WiBox *a, WiBox *b);
void RAtoBox(int *a, WiBox *b);

// --------------------------

void PrepareComp()
{
	int i;
	rawOld = WiCreateRawImage();
	rawOld->Color = 1;
	rawOld->BitsPerPixel = 24;
	rawOld->Height = RGBIMWIDTH;
	rawOld->Width = RGBIMWIDTH;

	rawImage = WiCreateRawImage();
	rawImage->Color = 0;
	rawImage->BitsPerPixel = 12;
	rawImage->Height = RGBIMWIDTH;
	rawImage->Width = RGBIMWIDTH;

	regionMap = (WiBox *)malloc(sizeof(WiBox)*MAXCMP_BLOCKS);
//	CopyBox(&frontRegion, &regionMap[0]);   /* frontRegion */
//	CopyBox(&topRegion, &regionMap[0]);     /* Top Region */
//	CopyBox(&backRegion, &regionMap[1]);	/* backRegion */
//	CopyBox(&leftRegion, &regionMap[2]);	/* leftRegion */
//	CopyBox(&rightRegion, &regionMap[3]);	/* rightRegion */
//	CopyBox(&offRegion, &regionMap[4]);		/* topRegion */


	/* step 2c: construct Focus Map */
	focusBoxes = (WiBox *)malloc(sizeof(WiBox)*MAXCMP_BLOCKS);
//	CopyBox(&leftRegion, &focusBoxes[0]);		/* frontRegion */
//	CopyBox(&rightRegion, &focusBoxes[1]);	    /* backRegion */
//	CopyBox(&bridgeRegion, &focusBoxes[2]);		/* bridge */

	for (i=0;i<2;i++)
	{
		WiOldBufs[i] = WiCreateCmpImage();
		WiOldBufs[i]->CmpData=CmpOldBufs[i];
		WiOldBufs[i]->Size=CMPIMSIZE;
	}
	for (i=0;i<6;i++)
	{
		WiImageBufs[i] = WiCreateCmpImage();
		WiImageBufs[i]->CmpData=CmpImageBufs[i];
		WiImageBufs[i]->Size=CMPIMSIZE;
	}


	cmpOpts = WiCreateCmpOptions();
	SetCompressionOptions( cmpOpts );
	return;
}

void SetCompressionOptions(WiCmpOptions *cmpOpts)
{
	cmpOpts->CmpControl=CR_QUALITY;
	cmpOpts->Quality =(float)0.82;
	cmpOpts->CmpRatio = (float)60;
	cmpOpts->Encoder=E_SLOW;
	cmpOpts->EncodePath=P_PATH1;
	cmpOpts->Magnification=0;
	cmpOpts->EdgeEnhancement=1;
	cmpOpts->ContrastEnhancement=0;
	cmpOpts->nBoxes=0;
	cmpOpts->nBlocks = 0;
	cmpOpts->BlockSize = SP_OFF;                  
	cmpOpts->Blocks = (WiBox *)malloc(sizeof(WiBox)*MAXCMP_BLOCKS);
	cmpOpts->FocusWeight=0;
	cmpOpts->FocusBoxes = (WiBox *)malloc(sizeof(WiBox)*MAXCMP_FOCUS);
	return;
}

void SetCompressionRegion(WiCmpOptions *cmpOpts, WiBox *regionMap)
{
	/* set SAM block coordinates */
 	for (int i = 0; i < cmpOpts->nBlocks; i++)
	{
		CopyBox(&regionMap[i], &cmpOpts->Blocks[i]); 
	}
	
}

void SetCompressionFocus(WiCmpOptions *cmpOpts, WiBox *focusBoxes)
{
	/* Set Focus box coordinates */
	for (int i = 0; i < cmpOpts->nBoxes; i++)
	{
		CopyBox(&focusBoxes[i], &cmpOpts->FocusBoxes[i]);
	}
	
}

void RAtoBox(int *a, WiBox *b)
{
	b->Left = a[0];
	b->Top  = a[1];
	b->Right= a[2];
	b->Bottom=a[3];
	return;
}

void CopyBox(WiBox *a, WiBox *b)
{
	b->Left = a->Left;
	b->Top = a->Top;
	b->Right = a->Right;
	b->Bottom = a->Bottom;
}

void InitComp0Thread()
{
	DWORD Comp0ThreadId;
	//printf("Initializing Comp0Thread.\n");
	
	hComp0Thread = CreateThread( 
        NULL,						// no security attributes        
        0,							// use default stack size        
        (LPTHREAD_START_ROUTINE) Comp0Thread, // thread function       
        NULL,						// argument to thread function   
        0,							// use default creation flags    
        &Comp0ThreadId);			// returns the thread identifier 
	return;
}

void InitComp1Thread()
{
	DWORD Comp1ThreadId;
	//printf("Initializing Comp1Thread.\n");
	
	hComp1Thread = CreateThread( 
        NULL,						// no security attributes        
        0,							// use default stack size        
        (LPTHREAD_START_ROUTINE) Comp1Thread, // thread function       
        NULL,						// argument to thread function   
        0,							// use default creation flags    
        &Comp1ThreadId);			// returns the thread identifier 
	return;
}

void Comp0Thread()
{
	DWORD evnt;

	printf("Starting Comp0Thread.\n"); 
	Comp0Event[COMPRESS_END]=CreateEvent(NULL,FALSE,FALSE,"ExitComp0Thread");
	Comp0Event[COMPRESS_GO]=CreateEvent(NULL,FALSE,FALSE,"Comp0Compress");
	Comp0Event[COMPRESS_OLD]=CreateEvent(NULL,FALSE,FALSE,"Comp0OldComp");
	while (1)
	{
		evnt = WaitForMultipleObjects(3,Comp0Event, FALSE, INFINITE)-WAIT_OBJECT_0;
		switch (evnt)
		{
		case COMPRESS_END:
			return;

		case COMPRESS_OLD:
			CompressImage(COMP0OLDBUF);
			SetEvent(NddsSendEvent[NDDSSEND_COMP0OLD]);
			if (PanoRun) SetEvent(AcqColorEvent[ACQCOLOR_TOCOMP0]);
			break;
			
		case COMPRESS_GO:
			CompressImage(COMP0REDBUF);
			SetEvent(NddsSendEvent[NDDSSEND_COMP0RED]);
			CompressImage(COMP0GREENBUF);
			SetEvent(NddsSendEvent[NDDSSEND_COMP0GREEN]);
			CompressImage(COMP0BLUEBUF);
			SetEvent(NddsSendEvent[NDDSSEND_COMP0BLUE]);
			if (PanoRun) SetEvent(AcqColorEvent[ACQCOLOR_TOCOMP0]);
			break;
		}
	}
	return;
}

void Comp1Thread()
{
	DWORD evnt;

	printf("Starting Comp1Thread.\n");
	Comp1Event[COMPRESS_END]=CreateEvent(NULL,FALSE,FALSE,"ExitComp1Thread");
	Comp1Event[COMPRESS_GO]=CreateEvent(NULL,FALSE,FALSE,"Comp1Compress");
	Comp1Event[COMPRESS_OLD]=CreateEvent(NULL,FALSE,FALSE,"Comp1OldComp");
	while (1)
	{
		evnt = WaitForMultipleObjects(3,Comp1Event, FALSE, INFINITE)-WAIT_OBJECT_0;
		switch (evnt)
		{
		case COMPRESS_END:
			return;

		case COMPRESS_OLD:
			CompressImage(COMP1OLDBUF);
			SetEvent(NddsSendEvent[NDDSSEND_COMP1OLD]);
			if (PanoRun) SetEvent(AcqColorEvent[ACQCOLOR_TOCOMP1]);
			break;
			
		case COMPRESS_GO:
			CompressImage(COMP1REDBUF);
			SetEvent(NddsSendEvent[NDDSSEND_COMP1RED]);
			CompressImage(COMP1GREENBUF);
			SetEvent(NddsSendEvent[NDDSSEND_COMP1GREEN]);
			CompressImage(COMP1BLUEBUF);
			SetEvent(NddsSendEvent[NDDSSEND_COMP1BLUE]);
			if (PanoRun) SetEvent(AcqColorEvent[ACQCOLOR_TOCOMP1]);
			break;
		}
	}
	return;
}

void EndComp0Thread()
{
	DWORD returnValue;

	SetEvent (Comp0Event[COMPRESS_END]);
	returnValue = WaitForSingleObject(hComp0Thread, INFINITE)-WAIT_OBJECT_0;
	if (returnValue)
	{
		printf ("Wait for thread to complete failed.\n");
	}
	printf("Comp0Thread ended.\n");
	return;
}

void EndComp1Thread()
{
	DWORD returnValue;

	SetEvent(Comp1Event[COMPRESS_END]);
	returnValue = WaitForSingleObject(hComp1Thread, INFINITE)-WAIT_OBJECT_0;
	if (returnValue)
	{
		printf ("Wait for thread to complete failed.\n");
	}
	printf("Comp1Thread ended.\n");
	return;
}

void CompressImage(int bufnum)
{
	int rv;

	if (OldRGBColor)
	{
		rawOld->Raw=RGBOldBufs[bufnum];
		rv=WiCompress(cmpOpts,rawOld,WiOldBufs[bufnum]);
		//StreamCmpToFile(WiOldBufs[bufnum]);
	}
	else
	{
		rawImage->Raw=RGBImageBufs[bufnum];
		rv=WiCompress(cmpOpts,rawImage,WiImageBufs[bufnum]);
	}
	if (rv!=0) printf("Summus: Error code returned %d.\n",rv);

	return;
}

void SaveCmpToFile(WiCmpImage *cmpImage)
{
	FILE* fp;
	printf("SavingCmpToFile.\n");
	fp=fopen("c:\\panobin\\CmpImage.wi","wb");
	fwrite(cmpImage->CmpData,1,cmpImage->Size,fp);
	fflush(fp);
	fclose(fp);
	return;
}

void StreamCmpToFile(WiCmpImage *cmpImage)
{
	FILE* fp;
	char filename[80];
	time_t ltime;
	struct _timeb tstruct;
    int tval;

	printf("StreamingCmpToFile.\n");
	time( &ltime );
	_ftime( &tstruct );
	tval = (ltime%1000000)*1000+tstruct.millitm;
	strcpy(filename,"c:\\newrun\\");
	strcat(filename,"PanCmp");
	_itoa(tval,&filename[strlen(filename)],10);
	strcat(filename,".wi");
	fp=fopen(filename,"wb");
	fwrite(cmpImage->CmpData,1,cmpImage->Size,fp);
	fflush(fp);
	fclose(fp);
	return;
}