package state;

import javax.swing.*;
import java.awt.*;

class stateTabbedPane extends JTabbedPane {
  JPanel sensor, other;
  VitalsPanel vitals;
  WeatherPanel weather;
  ElectricPanel electric;
  
  stateTabbedPane() {
    vitals = new VitalsPanel();
    sensor = new JPanel();
    weather = new WeatherPanel();
    electric = new ElectricPanel();

    setPreferredSize(new Dimension(540,420));
    
    addTab("Vitals", null, vitals, "Robot Vitals");
    addTab("Sensors", null, sensor, "Sensors/Wrist Position");
    addTab("Weather", null, weather, "Current Weather Conditions");
    addTab("Electrical", null, electric, "Electronics Status");
  }

  // update functions

  synchronized public void setGPS(double x, double y, double z)
    { vitals.setGPS(x,y,z); }
  synchronized public void setRobotSpeed(int speed)
    { vitals.setRobotSpeed(speed); }
  synchronized public void setRadius(int rad)
    { vitals.setRadius(rad); }
  synchronized public void setWheelSpeed(int ur, int ul, int lr, int ll)
    { vitals.setWheelSpeed(ur, ul, lr, ll); }
  synchronized public void setAmps(boolean ure, boolean ule, boolean lre,
				   boolean lle, boolean sre, boolean sle,
				   boolean urf, boolean ulf, boolean lrf,
				   boolean llf, boolean srf, boolean slf) {
    vitals.setAmps(ure, ule, lre, lle, sre, sle, urf, ulf, lrf, llf, srf, slf);
  }
  synchronized public void setTemp(int i, int o)
    { vitals.setTemp(i); weather.setTemp(i,o);}
  synchronized public void setPressure(int p) { weather.setPressure(p); }
  synchronized public void setWind(short s, short g, int c, short d)
    { weather.setWind(s,g,c,d); }
  synchronized public void setOdometer(long dist) { vitals.setOdometer(dist); }
  synchronized public void setTime(long t) { vitals.setTime(t); }
  synchronized public void setDriveMode(int m) { vitals.setDriveMode(m); }
  synchronized public void setCurrents(int c[], int m[], int s[])
    { electric.setCurrents(c, m, s); }
  synchronized public void setMotors(int p[], int s[])
    { electric.setMotors(p, s); }
}
