package state;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;

class RollPitchPanel extends JPanel {
  RPcircle rpc;
  JLabel Roll, rollLabel, Pitch, pitchLabel;
  Color textColor = new Color(102,102,153);

  volatile private double roll = 0.0, pitch = 0.0;

  RollPitchPanel() {
    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();

    setPreferredSize(new Dimension(180,120));

    setLayout(gridbag);

    setBorder(BorderFactory.createTitledBorder("Roll/Pitch"));

    c.gridheight = 5; c.gridwidth = 1;
    c.gridx = 0; c.gridy = 0;
    rpc = new RPcircle();
    gridbag.setConstraints(rpc, c);
    add(rpc);

    c.anchor = GridBagConstraints.NORTHWEST;
    
    c.gridheight = 1; c.gridwidth = 1;
    c.gridx = 1; c.gridy = 0;
    Roll = new JLabel("Roll");
    Roll.setHorizontalAlignment(JLabel.LEFT);
    gridbag.setConstraints(Roll, c);
    add(Roll);

    c.gridx = 1; c.gridy = 1;
    rollLabel = new JLabel("0.0 d");
    rollLabel.setHorizontalAlignment(JLabel.LEFT);
    rollLabel.setVerticalAlignment(JLabel.CENTER);
    rollLabel.setBorder(BorderFactory.createLoweredBevelBorder());
    rollLabel.setPreferredSize(new Dimension(80,20));
    gridbag.setConstraints(rollLabel, c);
    add(rollLabel);

    c.gridx = 1; c.gridy = 2;
    add(Box.createVerticalStrut(20), c);

    c.gridx = 1; c.gridy = 3;
    Pitch = new JLabel("Pitch");
    Pitch.setHorizontalAlignment(JLabel.LEFT);
    gridbag.setConstraints(Pitch, c);
    add(Pitch);

    c.gridx = 1; c.gridy = 4;
    pitchLabel = new JLabel("0.0 d");
    pitchLabel.setHorizontalAlignment(JLabel.LEFT);
    pitchLabel.setVerticalAlignment(JLabel.CENTER);
    pitchLabel.setBorder(BorderFactory.createLoweredBevelBorder());
    pitchLabel.setPreferredSize(new Dimension(80,20));
    gridbag.setConstraints(pitchLabel, c);
    add(pitchLabel);
  }

  synchronized void setRoll(double r) {
    roll = r;
    if (roll >= 20 || roll <= -20) rollLabel.setForeground(Color.red);
    else rollLabel.setForeground(textColor);
    rollLabel.setText(roll+" d");
    rpc.setRoll(r);
    repaint();
  }
  synchronized void setPitch(double p) {
    pitch = p;
    if (pitch >= 20 || pitch <= -20) pitchLabel.setForeground(Color.red);
    else pitchLabel.setForeground(textColor);
    pitchLabel.setText(pitch+" d");
    rpc.setPitch(p);
    repaint();
  }
  
}

class RPcircle extends JPanel {
  volatile double roll = 0.0, pitch = 0.0;
  Color sky, ground;

  RPcircle() {
    setPreferredSize(new Dimension(90,90));
    sky = Color.blue.brighter();
    ground = Color.white;
  }

  synchronized void setRoll(double r) {
    roll = r;
    if (roll >= 20 || roll <= -20 || pitch >= 20 || pitch <= -20) {
      sky = Color.red.brighter();  ground = Color.red.darker();
    } else {
      sky = Color.blue.brighter();  ground = Color.white;
    }
  }
  synchronized void setPitch(double p) {
    pitch = p;
    if (roll >= 20 || roll <= -20 || pitch >= 20 || pitch <= -20) {
      sky = Color.red.brighter();  ground = Color.red.darker();
    } else {
      sky = Color.blue.brighter();  ground = Color.white;
    }
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    Graphics2D g2 = (Graphics2D) g;

    setOpaque(true);

    g2.setColor(sky);
    g2.fill(new Ellipse2D.Double(5, 5, 80, 80));

    g2.setColor(ground);
    g2.fill(new Arc2D.Double(5, 5, 80, 80,          // enlarged to fix border
			     180 + (pitch*3) + roll,  // starting angle
			     180 - (pitch*6),         // extent of arc
			     Arc2D.CHORD));

    g2.setColor(Color.black);
    g2.draw(new Line2D.Double(5, 45, 85, 45));
    g2.setStroke(new BasicStroke(2.0f));
    g2.draw(new Ellipse2D.Double(5, 5, 80, 80));
  }
  
}
