package state;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import tools.*;

class HeadingPanel extends JPanel {
  JLabel labelNumber, labelDir;
  CompassPanel compassPanel;
  JPanel box;

  volatile private double heading = 0.0;

  HeadingPanel() {
    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();

    setPreferredSize(new Dimension(180,120));

    setLayout(gridbag);

    setBorder(BorderFactory.createTitledBorder("Heading"));
    
    c.gridwidth = 1; c.gridheight = 1;
    c.gridx = 0; c.gridy = 0;
    compassPanel = new CompassPanel();
    gridbag.setConstraints(compassPanel, c);
    add(compassPanel);

    c.anchor = GridBagConstraints.CENTER;
    c.gridwidth = 1; c.gridheight = 1;
    c.gridx = 1; c.gridy = 0;
    box = new JPanel(new GridLayout(2,1));
    box.setPreferredSize(new Dimension(70,50));
    box.setBorder(BorderFactory.createLoweredBevelBorder());
    gridbag.setConstraints(box, c);
    add(box);

    
    labelNumber = new JLabel("0.0");
    labelNumber.setPreferredSize(new Dimension(70,20));
    labelNumber.setHorizontalAlignment(JLabel.CENTER);
    box.add(labelNumber);

    labelDir = new JLabel("N");
    labelDir.setPreferredSize(new Dimension(70,20));
    labelDir.setHorizontalAlignment(JLabel.CENTER);
    box.add(labelDir);
  }

  synchronized void setHeading(int h) {
    heading = Math.toDegrees(((double)h)/100.0);

    compassPanel.setHeading(heading);
    
    // change based on heading input method...
    
    if(heading == 0 || heading == 360) {
      labelDir.setText("N");
      heading = 0;
    } else if (heading == 180) {
      labelDir.setText("S");
      heading = 0;
    } else if (heading == 90) {
      labelDir.setText("E");
      heading = 0;
    } else if (heading == 270) {
      labelDir.setText("W");
      heading = 0;
    } else if (heading < 90) {
      labelDir.setText("E of N");
    } else if (heading < 180) {
      labelDir.setText("E of S");
      heading = 180 - heading;
    } else if (heading < 270) {
      labelDir.setText("W of S");
      heading = heading - 180;
    } else {
      labelDir.setText("W of N");
      heading = 360 - heading;
    }
      
    labelNumber.setText(Double.toString(Format.round(heading,1)));
    repaint();
  }
}

