package state;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import tools.*;

class ElectricPanel extends JPanel {

  // All labels for table:
  //   F = Front, B = Back, S = Steer, R = Right, L = Left,
  //   T = Total, P = Power, all end in _l (for label)
  //   command = commanded current to servo (amps)
  //   monitored = monitored current (from amplifier, amps)
  //   sense = sensed current (from hall effect sensor, amps)
  //   power = power going to motors (watts)
  //   speed = speed of the motor (rpm)

  JLabel FL_command_l, FL_monitor_l, FL_sense_l, FL_power_l, FL_speed_l;
  JLabel FR_command_l, FR_monitor_l, FR_sense_l, FR_power_l, FR_speed_l;
  JLabel BL_command_l, BL_monitor_l, BL_sense_l, BL_power_l, BL_speed_l;
  JLabel BR_command_l, BR_monitor_l, BR_sense_l, BR_power_l, BR_speed_l;
  JLabel SL_command_l, SL_monitor_l, SL_sense_l, SL_power_l, SL_speed_l;
  JLabel SR_command_l, SR_monitor_l, SR_sense_l, SR_power_l, SR_speed_l;
  JLabel T_command_l, T_monitor_l, T_sense_l, T_power_l, T_speed_l;
  JLabel P_one_l, P_two_l;

  // values in labels: same as labels but ending in _v

  int FL_command_v, FL_monitor_v, FL_sense_v, FL_power_v, FL_speed_v;
  int FR_command_v, FR_monitor_v, FR_sense_v, FR_power_v, FR_speed_v;
  int BL_command_v, BL_monitor_v, BL_sense_v, BL_power_v, BL_speed_v;
  int BR_command_v, BR_monitor_v, BR_sense_v, BR_power_v, BR_speed_v;
  int SL_command_v, SL_monitor_v, SL_sense_v, SL_power_v, SL_speed_v;
  int SR_command_v, SR_monitor_v, SR_sense_v, SR_power_v, SR_speed_v;
  int T_command_v, T_monitor_v, T_sense_v, T_power_v, T_speed_v;
  JLabel P_one_v, P_two_v;
  
  ElectricPanel() {
    // set up panel
    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();

    setLayout(gridbag);
    c.anchor = GridBagConstraints.WEST;

    // Labels for top of table
    c.gridwidth = 1; c.gridheight = 3;
    c.gridx = 0; c.gridy = 0;
    add(Box.createRigidArea(new Dimension(90,60)), c);

    c.gridwidth = 3; c.gridheight = 1;
    c.gridx = 1;
    JLabel current = new JLabel("Currents");
    current.setHorizontalAlignment(JLabel.CENTER);
    current.setPreferredSize(new Dimension(270,20));
    current.setBorder(BorderFactory.createEtchedBorder(
      getBackground().darker(), getBackground().brighter()));
    add(current, c);

    c.gridwidth = 2;
    c.gridx = 4;
    JLabel motor = new JLabel("Motors");
    motor.setHorizontalAlignment(JLabel.CENTER);
    motor.setPreferredSize(new Dimension(160,20));
    motor.setBorder(BorderFactory.createEtchedBorder(
      getBackground().darker(), getBackground().brighter()));
    add(motor, c);

    c.gridwidth = 1;
    c.gridx = 1; c.gridy = 1;
    JLabel command = new JLabel("Commanded");
    command.setHorizontalAlignment(JLabel.CENTER);
    command.setPreferredSize(new Dimension(100,20));
    add(command, c);

    c.gridx = 2;
    JLabel monitor = new JLabel("Monitored");
    monitor.setHorizontalAlignment(JLabel.CENTER);
    monitor.setPreferredSize(new Dimension(90,20));
    add(monitor, c);

    c.gridx = 3;
    JLabel sense = new JLabel("Sensed");
    sense.setHorizontalAlignment(JLabel.CENTER);
    sense.setPreferredSize(new Dimension(80,20));
    add(sense, c);

    c.gridx = 4;
    JLabel power = new JLabel("Power");
    power.setHorizontalAlignment(JLabel.CENTER);
    power.setPreferredSize(new Dimension(80,20));
    add(power, c);

    c.gridx = 5;
    JLabel speed = new JLabel("Speed");
    speed.setHorizontalAlignment(JLabel.CENTER);
    speed.setPreferredSize(new Dimension(80,20));
    add(speed, c);

    c.gridx = 1; c.gridy = 2;
    JLabel command_a = new JLabel("(Amps)");
    command_a.setHorizontalAlignment(JLabel.CENTER);
    command_a.setPreferredSize(new Dimension(100,20));
    add(command_a, c);

    c.gridx = 2;
    JLabel monitor_a = new JLabel("(Amps)");
    monitor_a.setHorizontalAlignment(JLabel.CENTER);
    monitor_a.setPreferredSize(new Dimension(90,20));
    add(monitor_a, c);

    c.gridx = 3;
    JLabel sense_a = new JLabel("(Amps)");
    sense_a.setHorizontalAlignment(JLabel.CENTER);
    sense_a.setPreferredSize(new Dimension(80,20));
    add(sense_a, c);

    c.gridx = 4;
    JLabel power_w = new JLabel("(Watts)");
    power_w.setHorizontalAlignment(JLabel.CENTER);
    power_w.setPreferredSize(new Dimension(80,20));
    add(power_w, c);

    c.gridx = 5;
    JLabel speed_rpm = new JLabel("(RPM)");
    speed_rpm.setHorizontalAlignment(JLabel.CENTER);
    speed_rpm.setPreferredSize(new Dimension(80,20));
    add(speed_rpm, c);

    // Front Left Wheel values and label
    c.gridx = 0; c.gridy = 3;
    JLabel FLlabel = new JLabel("Front Left");
    FLlabel.setHorizontalAlignment(JLabel.LEFT);
    FLlabel.setPreferredSize(new Dimension(90,20));
    add(FLlabel, c);

    addLabel(FL_command_l, 1, 3, 100, c);
    addLabel(FL_monitor_l, 2, 3, 90, c);
    addLabel(FL_sense_l, 3, 3, 80, c);
    addLabel(FL_power_l, 4, 3, 80, c);
    addLabel(FL_speed_l, 5, 3, 80, c);

    // Front Right Wheel values and label
    c.gridx = 0; c.gridy = 4;
    JLabel FRlabel = new JLabel("Front Right");
    FRlabel.setHorizontalAlignment(JLabel.LEFT);
    FRlabel.setPreferredSize(new Dimension(90,20));
    add(FRlabel, c);

    addLabel(FR_command_l, 1, 4, 100, c);
    addLabel(FR_monitor_l, 2, 4, 90, c);
    addLabel(FR_sense_l, 3, 4, 80, c);
    addLabel(FR_power_l, 4, 4, 80, c);
    addLabel(FR_speed_l, 5, 4, 80, c);

    // Back Left Wheel values and label
    c.gridx = 0; c.gridy = 5;
    JLabel BLlabel = new JLabel("Back Left");
    BLlabel.setHorizontalAlignment(JLabel.LEFT);
    BLlabel.setPreferredSize(new Dimension(90,20));
    add(BLlabel, c);

    addLabel(BL_command_l, 1, 5, 100, c);
    addLabel(BL_monitor_l, 2, 5, 90, c);
    addLabel(BL_sense_l, 3, 5, 80, c);
    addLabel(BL_power_l, 4, 5, 80, c);
    addLabel(BL_speed_l, 5, 5, 80, c);

    // Back Right Wheel values and label
    c.gridx = 0; c.gridy = 6;
    JLabel BRlabel = new JLabel("Back Right");
    BRlabel.setHorizontalAlignment(JLabel.LEFT);
    BRlabel.setPreferredSize(new Dimension(90,20));
    add(BRlabel, c);

    addLabel(BR_command_l, 1, 6, 100, c);
    addLabel(BR_monitor_l, 2, 6, 90, c);
    addLabel(BR_sense_l, 3, 6, 80, c);
    addLabel(BR_power_l, 4, 6, 80, c);
    addLabel(BR_speed_l, 5, 6, 80, c);

    // Left Steering values and label
    c.gridx = 0; c.gridy = 7;
    JLabel SLlabel = new JLabel("Left Steer");
    SLlabel.setHorizontalAlignment(JLabel.LEFT);
    SLlabel.setPreferredSize(new Dimension(90,20));
    add(SLlabel, c);

    addLabel(SL_command_l, 1, 7, 100, c);
    addLabel(SL_monitor_l, 2, 7, 90, c);
    addLabel(SL_sense_l, 3, 7, 80, c);
    addLabel(SL_power_l, 4, 7, 80, c);
    addLabel(SL_speed_l, 5, 7, 80, c);

    // Right Steering values and label
    c.gridx = 0; c.gridy = 8;
    JLabel SRlabel = new JLabel("Right Steer");
    SRlabel.setHorizontalAlignment(JLabel.LEFT);
    SRlabel.setPreferredSize(new Dimension(90,20));
    add(SRlabel, c);

    addLabel(SR_command_l, 1, 8, 100, c);
    addLabel(SR_monitor_l, 2, 8, 90, c);
    addLabel(SR_sense_l, 3, 8, 80, c);
    addLabel(SR_power_l, 4, 8, 80, c);
    addLabel(SR_speed_l, 5, 8, 80, c);

    c.gridwidth = 6;
    c.gridx = 0; c.gridy = 9;
    add(Box.createVerticalStrut(10), c);

    // Total values and label
    c.gridy = 10;
    JLabel Tlabel = new JLabel("Totals");
    Tlabel.setHorizontalAlignment(JLabel.LEFT);
    Tlabel.setPreferredSize(new Dimension(90,20));
    add(Tlabel, c);

    addLabel(T_command_l, 1, 10, 100, c);
    addLabel(T_monitor_l, 2, 10, 90, c);
    addLabel(T_sense_l, 3, 10, 80, c);
    addLabel(T_power_l, 4, 10, 80, c);
    c.gridx = 5;
    add(Box.createRigidArea(new Dimension(80,20)), c);

    c.gridwidth = 6;
    c.gridx = 0; c.gridy = 11;
    add(Box.createVerticalStrut(25), c);

    c.gridwidth = 3;
    c.gridy = 12;
    JLabel psvLabel = new JLabel("Power Supply Voltages");
    psvLabel.setHorizontalAlignment(JLabel.LEFT);
    psvLabel.setPreferredSize(new Dimension(280,20));
    add(psvLabel, c);
    
    c.gridwidth = 6;
    c.gridx = 0; c.gridy = 13;
    add(Box.createVerticalStrut(5), c);

    c.gridwidth = 2;
    c.gridy = 14;
    JLabel P_1_label = new JLabel("Power Supply 1");
    P_1_label.setHorizontalAlignment(JLabel.LEFT);
    P_1_label.setPreferredSize(new Dimension(190,20));
    add(P_1_label, c);
    addLabel(P_one_l, 2, 14, 80, c);

    c.gridwidth = 2;
    c.gridx = 0; c.gridy = 15;
    JLabel P_2_label = new JLabel("Power Supply 2");
    P_2_label.setHorizontalAlignment(JLabel.LEFT);
    P_2_label.setPreferredSize(new Dimension(190,20));
    add(P_2_label, c);
    addLabel(P_two_l, 2, 15, 80, c);
  }

  private void addLabel(JLabel l, int x, int y, int w, GridBagConstraints c) {
    c.gridx = x;
    c.gridy = y;
    l = new JLabel("1000.000");
    l.setHorizontalAlignment(JLabel.CENTER);
    l.setPreferredSize(new Dimension(w,20));
    l.setBorder(BorderFactory.createLoweredBevelBorder());
    add(l, c);
  }

  synchronized public void setCurrents(int c[], int m[], int s[]) {
    FL_command_v = c[3];  FL_monitor_v = m[3];  FL_sense_v = s[3];
    FR_command_v = c[2];  FR_monitor_v = m[2];  FR_sense_v = s[2];
    BL_command_v = c[1];  BL_monitor_v = m[1];  BL_sense_v = s[1];
    BR_command_v = c[0];  BR_monitor_v = m[0];  BR_sense_v = s[0];
    SL_command_v = c[5];  SL_monitor_v = m[5];  SL_sense_v = s[5];
    SR_command_v = c[4];  SR_monitor_v = m[4];  SR_sense_v = s[4];

    FL_command_l.setText(Double.toString((double)FL_command_v/1000.0));
    FL_monitor_l.setText(Double.toString((double)FL_monitor_v/1000.0));
    FL_sense_l.setText(Double.toString((double)FL_sense_v/1000.0));
    FR_command_l.setText(Double.toString((double)FR_command_v/1000.0));
    FR_monitor_l.setText(Double.toString((double)FR_monitor_v/1000.0));
    FR_sense_l.setText(Double.toString((double)FR_sense_v/1000.0));
    BL_command_l.setText(Double.toString((double)BL_command_v/1000.0));
    BL_monitor_l.setText(Double.toString((double)BL_monitor_v/1000.0));
    BL_sense_l.setText(Double.toString((double)BL_sense_v/1000.0));
    BR_command_l.setText(Double.toString((double)BR_command_v/1000.0));
    BR_monitor_l.setText(Double.toString((double)BR_monitor_v/1000.0));
    BR_sense_l.setText(Double.toString((double)BR_sense_v/1000.0));
    SL_command_l.setText(Double.toString((double)SL_command_v/1000.0));
    SL_monitor_l.setText(Double.toString((double)SL_monitor_v/1000.0));
    SL_sense_l.setText(Double.toString((double)SL_sense_v/1000.0));
    SR_command_l.setText(Double.toString((double)SR_command_v/1000.0));
    SR_monitor_l.setText(Double.toString((double)SR_monitor_v/1000.0));
    SR_sense_l.setText(Double.toString((double)SR_sense_v/1000.0));

    T_command_v = T_monitor_v = T_sense_v = 0;
    
    for(int x=0; x<6; x++) {
      T_command_v += c[x];
      T_monitor_v += m[x];
      T_sense_v += s[x];
    }

    T_command_l.setText(Double.toString((double)T_command_v/1000.0));
    T_monitor_l.setText(Double.toString((double)T_monitor_v/1000.0));
    T_sense_l.setText(Double.toString((double)T_sense_v/1000.0));
  }
  synchronized public void setMotors(int p[], int s[]) {
    FL_power_v = p[3];  FL_speed_v = s[3];
    FR_power_v = p[2];  FR_speed_v = s[2];
    BL_power_v = p[1];  BL_speed_v = s[1];
    BR_power_v = p[0];  BR_speed_v = s[0];
    SL_power_v = p[5];  SL_speed_v = s[5];
    SR_power_v = p[4];  SR_speed_v = s[4];

    FL_power_l.setText(Double.toString((double)FL_power_v/1000.0));
    FL_speed_l.setText(Double.toString((double)FL_speed_v/1000.0));
    FR_power_l.setText(Double.toString((double)FR_power_v/1000.0));
    FR_speed_l.setText(Double.toString((double)FR_speed_v/1000.0));
    BL_power_l.setText(Double.toString((double)BL_power_v/1000.0));
    BL_speed_l.setText(Double.toString((double)BL_speed_v/1000.0));
    BR_power_l.setText(Double.toString((double)BR_power_v/1000.0));
    BR_speed_l.setText(Double.toString((double)BR_speed_v/1000.0));
    SL_power_l.setText(Double.toString((double)SL_power_v/1000.0));
    SL_speed_l.setText(Double.toString((double)SL_speed_v/1000.0));
    SR_power_l.setText(Double.toString((double)SR_power_v/1000.0));
    SR_speed_l.setText(Double.toString((double)SR_speed_v/1000.0));

    T_power_v = T_speed_v = 0;
    
    for(int x=0; x<6; x++) {
      T_power_v += p[x];
      T_speed_v += s[x];
    }

    T_power_l.setText(Double.toString((double)T_power_v/1000.0));
    T_speed_l.setText(Double.toString((double)T_speed_v/1000.0));
  }
}
