package nomadgui.state;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;

public class RSPFrame extends JInternalFrame {

  private Container contentPane;

  TopPanel top;
  SidePanel side;
  HeadingPanel heading;
  SpeedPanel speed;
  RollPitchPanel roll_pitch;
  stateTabbedPane tabs;
  
  public RSPFrame(String title, boolean resizable, boolean closable,
	   boolean maximizable, boolean iconifiable) {
    super(title, resizable, closable, maximizable, iconifiable);

    setDefaultCloseOperation(JInternalFrame.DISPOSE_ON_CLOSE);
    
    contentPane = getContentPane();

    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();

    contentPane.setLayout(gridbag);

    c.anchor = GridBagConstraints.SOUTH;
    
    // Top View Panel
    c.gridheight = 1; c.gridwidth = 1;
    c.gridx = 0; c.gridy = 0;
    top = new TopPanel();
    gridbag.setConstraints(top, c);
    contentPane.add(top);

    // Tabbed State Panel
    c.gridheight = 2; c.gridwidth = 3;
    c.gridx = 1; c.gridy = 0;
    tabs = new stateTabbedPane();
    gridbag.setConstraints(tabs, c);
    contentPane.add(tabs);

    // Side View Panel
    c.gridheight = 2; c.gridwidth = 1;
    c.gridx = 0; c.gridy = 1;
    side = new SidePanel();
    gridbag.setConstraints(side, c);
    contentPane.add(side);

    // Roll/Pitch Panel
    c.gridheight = 1; c.gridwidth = 1;
    c.gridx = 1; c.gridy = 2;
    roll_pitch = new RollPitchPanel();
    gridbag.setConstraints(roll_pitch, c);
    contentPane.add(roll_pitch);
    
    // Speed Panel
    c.gridheight = 1; c.gridwidth = 1;
    c.gridx = 2; c.gridy = 2;
    speed = new SpeedPanel();
    gridbag.setConstraints(speed, c);
    contentPane.add(speed);

    // Heading Panel
    c.gridheight = 1; c.gridwidth = 1;
    c.gridx = 3; c.gridy = 2;
    heading = new HeadingPanel();
    gridbag.setConstraints(heading, c);
    contentPane.add(heading);
  }

  // update functions: methods to update data in the panels

  synchronized public void setRoll(float r) { roll_pitch.setRoll(r); }
  synchronized public void setPitch(float p) { roll_pitch.setPitch(p); }
  synchronized public void setRobotSpeed(int s)
    { speed.setSpeed(s); tabs.setRobotSpeed(s); }
  synchronized public void setRadius(int rad) { tabs.setRadius(rad); }
  synchronized public void setHeading(int h) { heading.setHeading(h); }
  synchronized public void setTheta(float t)
    { side.setTheta(t); top.setTheta(t); }
  synchronized public void setPhi(float p) { side.setPhi(p); top.setPhi(p); }
  synchronized public void setAlpha(float a) { side.setAlpha(a); }
  synchronized public void setBogie(float b) { side.setBogie(b); }
  synchronized public void setLinks(float gr, float gl)
    { top.setLinks(gr, gl); }
  synchronized public void setWheelSpeed(int ur, int ul, int lr, int ll) {
    tabs.setWheelSpeed(ur, ul, lr, ll);
    if (ur+ul+lr+ll < 0) speed.setNegative(true);
    else speed.setNegative(false);
  }
  synchronized public void setAmps(boolean ure, boolean ule, boolean lre,
				   boolean lle, boolean sre, boolean sle,
				   boolean urf, boolean ulf, boolean lrf,
				   boolean llf, boolean srf, boolean slf) {
    tabs.setAmps(ure, ule, lre, lle, sre, sle, urf, ulf, lrf, llf, srf, slf); }
  synchronized public void setTemp(int i, int o) { tabs.setTemp(i,o); }
  synchronized public void setGPS(float x, float y, float z)
    { tabs.setGPS(x,y,z); }
  synchronized public void setPressure(int p) { tabs.setPressure(p); }
  synchronized public void setWind(short s, short g, int c, short d)
    { tabs.setWind(s,g,c,d); }
  synchronized public void setOdometer(long dist) { tabs.setOdometer(dist); }
  synchronized public void setTime(long t) { tabs.setTime(t); }
  synchronized public void setDriveMode(int m) { tabs.setDriveMode(m); }
  synchronized public void setCurrents(float c[], float m[], float s[])
    { tabs.setCurrents(c, m, s); }
  synchronized public void setMotors(float p[], float s[])
    { tabs.setMotors(p, s); }
  synchronized public void setFOV(float p, float t, float f)
    { top.setFOV(p,t,f);  side.setFOV(p,t,f); }
}
