package nomadgui.control;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;

/** An extension of JInternalFrame that sets up the Control Panel for
  * the robot.  The entire control panel is taken up by a tabbed pane
  * which provides different methods of control.
  * @see nomad.control.controlTabbedPane
  */

public class RCPFrame extends JInternalFrame {

  private Container contentPane;
  private controlTabbedPane tabs;

  /** Default Constructor.  Creates an instance of RCPFrame with title
    * "Control" that is resizable, closable, maximizable, and iconifiable.
    */
  
  public RCPFrame() { this("Control", true, true, true, true); }

  /** Allows definition of the characteristics of this RCPFrame.  Creates
    * an instance of RCPFrame where the title and window characteristics
    * (resizable, closable, maximizable, and iconifiable) can be specified.
    * @param title The string to be displayed on the title bar of the window.
    * @param resizable Determines whether the window may be resized.
    * @param closable Determines whether the window may be closed.
    * @param maximizable Determines whether the window may be maximized.
    * @param iconifiable Determines whether the window may be iconified
    *                    (minimized).
    */
  
  public RCPFrame(String title, boolean resizable, boolean closable,
	   boolean maximizable, boolean iconifiable) {
    super(title, resizable, closable, maximizable, iconifiable);

    setDefaultCloseOperation(JInternalFrame.DISPOSE_ON_CLOSE);
    
    contentPane = getContentPane();
    tabs = new controlTabbedPane(JTabbedPane.LEFT);

    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();

    contentPane.setLayout(gridbag);

    c.anchor = GridBagConstraints.SOUTHWEST;

    // Strut to space the button
    c.gridx = 0; c.gridy = 1;
    c.gridheight = 2; c.gridwidth = 1;
    contentPane.add(Box.createHorizontalStrut(10), c);
    
    // JButton: E-Stop
    c.gridx = 1; c.gridy = 1;
    c.gridheight = 1; c.gridwidth = 1;
    JButton estop = new JButton("E-STOP", new ImageIcon("stop.gif"));
    estop.setVerticalTextPosition(JButton.TOP);
    estop.setHorizontalTextPosition(JButton.CENTER);
    estop.setBackground(Color.white);
    contentPane.add(estop, c);

    // Strut to space the button
    c.gridx = 1; c.gridy = 0;
    c.gridheight = 1; c.gridwidth = 1;
    contentPane.add(Box.createVerticalStrut(120), c);
    
    // Tabbed pane
    c.gridx = 0; c.gridy = 0;
    c.gridheight = 3; c.gridwidth = 3;
    contentPane.add(tabs, c);
  }

}
