package nomadgui.control;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import nomadgui.tools.*;

/** An extension of JPanel that provides for independent control of the robot.
  * The panel has an image of the robot with six text boxes used to specify the
  * speeds/positions of the six motors (two steering/four wheel).
  */

public class IndependentPanel extends JPanel {
  Image nomad;
  MediaTracker mt;

  // Fields: f = front, b = back, s = steer, r = right, l = left
  JTextField flField, frField, blField, brField, slField, srField;
  JLabel flLabel, frLabel, blLabel, brLabel, slLabel, srLabel;
  int fl_speed, fr_speed, bl_speed, br_speed, sl_speed, sr_speed;

  /** Default Constructor.  Creates a panel with an image of the robot
    * and six text boxes around the edges to specify speeds.
    */
  
  IndependentPanel() {
    mt = new MediaTracker(this);
    nomad = Toolkit.getDefaultToolkit().getImage("indep.gif");
    mt.addImage(nomad, 2);
    try { mt.waitForID(2); } catch(InterruptedException ie) {}
    
    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();

    c.anchor = GridBagConstraints.NORTH;
    
    setLayout(gridbag);

    c.gridx = 0; c.gridy = 0;
    c.gridwidth = 1; c.gridheight = 1;
    flLabel = new JLabel("Front Left");
    flLabel.setVerticalAlignment(JLabel.BOTTOM);
    flLabel.setPreferredSize(new Dimension(90,30));
    flLabel.setMinimumSize(new Dimension(90,30));
    add(flLabel, c);

    c.gridy = 1;
    flField = new JTextField("0");
    flField.setPreferredSize(new Dimension(90,30));
    flField.setMinimumSize(new Dimension(90,30));
    add(flField, c);
    
    c.gridy = 2;
    slLabel = new JLabel("Left Steer");
    slLabel.setVerticalAlignment(JLabel.BOTTOM);
    slLabel.setPreferredSize(new Dimension(90,50));
    slLabel.setMinimumSize(new Dimension(90,50));
    add(slLabel, c);

    c.gridy = 3;
    slField = new JTextField("0");
    slField.setPreferredSize(new Dimension(90,30));
    slField.setMinimumSize(new Dimension(90,30));
    add(slField, c);

    c.gridy = 4;
    blLabel = new JLabel("Rear Left");
    blLabel.setVerticalAlignment(JLabel.BOTTOM);
    blLabel.setPreferredSize(new Dimension(90,50));
    blLabel.setMinimumSize(new Dimension(90,50));
    add(blLabel, c);

    c.gridy = 5;
    blField = new JTextField("0");
    blField.setPreferredSize(new Dimension(90,30));
    blField.setMinimumSize(new Dimension(90,30));
    add(blField, c);

    c.gridx = 1; c.gridy = 0;
    c.gridwidth = 1; c.gridheight = 6;
    add(Box.createRigidArea(new Dimension(375,250)), c);  // space for image

    c.gridx = 2; c.gridy = 0;
    c.gridwidth = 1; c.gridheight = 1;
    frLabel = new JLabel("Front Right");
    frLabel.setVerticalAlignment(JLabel.BOTTOM);
    frLabel.setPreferredSize(new Dimension(90,30));
    frLabel.setMinimumSize(new Dimension(90,30));
    add(frLabel, c);

    c.gridy = 1;
    frField = new JTextField("0");
    frField.setPreferredSize(new Dimension(90,30));
    frField.setMinimumSize(new Dimension(90,30));
    add(frField, c);
    
    c.gridy = 2;
    srLabel = new JLabel("Right Steer");
    srLabel.setVerticalAlignment(JLabel.BOTTOM);
    srLabel.setPreferredSize(new Dimension(90,50));
    srLabel.setMinimumSize(new Dimension(90,50));
    add(srLabel, c);

    c.gridy = 3;
    srField = new JTextField("0");
    srField.setPreferredSize(new Dimension(90,30));
    srField.setMinimumSize(new Dimension(90,30));
    add(srField, c);

    c.gridy = 4;
    brLabel = new JLabel("Rear Right");
    brLabel.setVerticalAlignment(JLabel.BOTTOM);
    brLabel.setPreferredSize(new Dimension(90,50));
    brLabel.setMinimumSize(new Dimension(90,50));
    add(brLabel, c);

    c.gridy = 5;
    brField = new JTextField("0");
    brField.setPreferredSize(new Dimension(90,30));
    brField.setMinimumSize(new Dimension(90,30));
    add(brField, c);
  }

  /** Draws the independent panel.  This should not be called directly, but
    * should be called via repaint().
    * @param g The graphics context for this panel.
    */
  
  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    Graphics2D g2 = (Graphics2D) g;
    
    setBackground(Color.white);
    setOpaque(true);
    g2.drawImage(nomad, 90, 0, 375, 250, this);
  }
}

