package nomadgui;

import javax.swing.*;
import java.awt.*;

/** An extension of JDesktopPane with simple window organizing functions. */

class NomadDesktopPane extends JDesktopPane {

  private int cascade_w = 200, cascade_h = 200, cascade_offset = 20;

  /** Minimizes (iconifies) all open windows. */
  
  public void minimizeAll() {
    JInternalFrame[] frames = getAllFrames();

    for (int i=0; i<frames.length; ++i) {
      if (!frames[i].isIcon()) {
	try { frames[i].setIcon(true); }
	catch(java.beans.PropertyVetoException e) {
	  System.err.println("Iconification vetoed!");
	  System.err.println(e.toString());
	}
      }
    }
  }

  /** Opens all minimized (iconified) windows. */

  public void openAll() {
    JInternalFrame[] frames = getAllFrames();

    for (int i=0; i<frames.length; ++i) {
      if (frames[i].isIcon()) {
	try { frames[i].setIcon(false); }
	catch(java.beans.PropertyVetoException e) {
	  System.err.println("Restoration vetoed!");
	  System.err.println(e.toString());
	}
      }
    }
  }

  /** Cascades all open windows.  Minimized (iconified) windows are not
    * cascaded.
    */
  
  public void cascade() {
    JInternalFrame[] frames = getAllFrames();
    int x=0, y=0;

    for (int i=0; i<frames.length; ++i) {
      if (!frames[i].isIcon()) {
	frames[i].setBounds(x, y, frames[i].getWidth(), frames[i].getHeight());
	x += cascade_offset;
	y += cascade_offset;
      }
    }
  }

}
