/*
 * --------------------------------------------------------------------
 *
 *  Copyright (C) Jochen Karrer 1997
 *
 *  Released under the terms of the GPL.
 *
 * --------------------------------------------------------------------
 */
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <tcl.h>
#include <tk.h>
#include <blt.h>

typedef struct {
        Tcl_Interp *interp;
	Tcl_Channel channel;
	Blt_VectorId vecId;
	Blt_Vector *vec;
	double data[2048];
	double weight[2048];
} S2000;

static void 
s2000_readspectrum(ClientData clientData,int mask) {
		S2000 *s2000 = (S2000*)clientData;
		static u_int buf[2048];
		int n,i;
		while((n=Tcl_Read(s2000->channel,(char*)buf,2048*sizeof(u_int) ))==2048*4) {
			for(i=0;i<2048;i++) {
				s2000->data[i] = ((double) buf[i])*s2000->weight[i];
			}
		}
		Blt_ResetVector(s2000->vec,s2000->data,2048,s2000->vec->arraySize,TCL_STATIC);
}  
static void 
s2000_do_destroy_link(Tcl_Interp *interp,S2000 *s2000) {
		Tcl_DeleteChannelHandler(s2000->channel,s2000_readspectrum,(ClientData)s2000);
		/*
		if(Blt_VectorExists(interp,Blt_NameOfVectorId(s2000->vecId))) {
			Blt_FreeVectorId(s2000->vecId);
		}
		*/
		free(s2000);
}
static int
s2000_destroy_link(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
	return TCL_OK;
}
void 
s2000_ChangeVec (Tcl_Interp *interp,
                   ClientData clientData, Blt_VectorNotify notify) {
	S2000 *s2000 = (S2000*)clientData;
	if(notify == BLT_VECTOR_NOTIFY_DESTROY	) {
//		fprintf(stderr,"Destroyed !!!!!!!!!!!!!!!!!\n");
		s2000_do_destroy_link(interp,s2000);
	}	
}

static int
s2000_create_link(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]) {
        Blt_Vector *vec,*vecScale;
	S2000 *s2000;
	Tcl_Channel channel;
	int mode;
	int i;

        if(argc<3) {
                interp->result=
		"to few arguments, usage: s2000_link_vector <devicehandle> <vector> ?ScaleVector?" ;
                return TCL_ERROR;
        }
	channel = Tcl_GetChannel(interp,argv[1], &mode);
	if((channel == 0) || !(mode & (TCL_READABLE)) ) {
		interp->result="illegal channel-handle";
		return TCL_ERROR;
	}
	if(Tcl_Write(channel,"bin\n",4) < 4) {
		interp->result ="can't write commands to spectrometer";	
		return TCL_ERROR;
	}
	Tcl_Flush(channel);
	s2000 = (S2000*) calloc(1,sizeof(S2000));
	if(s2000 == NULL) {
                interp->result = "Not enough memory for Spectrometer Control";
                return TCL_ERROR;
        }
	s2000->interp=interp;
	s2000->channel = channel;
 	s2000->vecId = Blt_AllocVectorId (interp,argv[2]); 
	
        if (Blt_GetVector(interp, argv[2], &vec) != TCL_OK) {
		free(s2000);
                return TCL_ERROR;
        }
	s2000->vec = vec;
	for(i=0;i<2048;i++) {
		s2000->weight[i] = 1;
	}
	if(argc >= 4) {
		int n;
        	if (Blt_GetVector(interp, argv[3], &vecScale) != TCL_OK) {
			Tcl_AppendResult(interp,argv[3],"is not a valid vector",NULL);
			return TCL_ERROR;
		}

		n = (vecScale->numValues >= 2048) ? 2048 : vecScale->numValues;
		for(i=0;i<n;i++) {
			s2000->weight[i] = vecScale->valueArr[i];
		}
	}
	Blt_SetVectorChangedProc (s2000->vecId, s2000_ChangeVec,(ClientData)s2000);
	Tcl_CreateChannelHandler(channel,TCL_READABLE,s2000_readspectrum,(ClientData)s2000);
        return TCL_OK;
}

int 
S_Init(Tcl_Interp *interp) {
	Tcl_CreateCommand(interp,"s2000_link_vector",s2000_create_link,
			(ClientData)NULL, (Tcl_CmdDeleteProc *) NULL);
	return TCL_OK;	
}
