/* 
 * pxc_show.c -- print on a terminal in "ascii scale"
 *
 * Copyright (C) 1995-1998 Alessandro Rubini  -- rubini@linux.it
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <termios.h> /* winsize */
#include <sys/ioctl.h>

int howmany;


char alpha[]=" .,:|IO#";

char *devname = "/dev/pxc0pgm";
char *prgname;

int main(int argc, char **argv)
{
    FILE *f;
    int x,y,X,Y;
    double xstep, ystep; 
    int xsize, ysize, count=1;
    struct winsize win;
    unsigned char *buf;
    char s[80];

    /* No command-line options, only the device name */
    prgname = argv[0];
    if (argc > 1 && argv[1][0] == '/') { /* first */
	devname = argv[1];
	argc--; argv++;
    } else if (argc > 1 && argv[argc-1][0] == '/') { /* last */
	devname = argv[argc-1];
	argc--;
    } else if (getenv("PXCDEVICE")) {
	devname = getenv("PXCDEVICE");
    }
    
    f = fopen(devname,"r");
    if (!f) {
	fprintf(stderr,"%s: %s: %s\n", prgname, devname, strerror(errno));
	exit(1);
    }
    
    fgets(s, 80, f);
    if (sscanf(s,"P5 %d %d", &xsize, &ysize) != 2) {
	fprintf(stderr,"%s: %s: not a pgm file\n", prgname, devname);
	exit(1);
    }

    /* window size */
    if (ioctl(1 /* stdout */, TIOCGWINSZ, &win)<0) {
        fprintf(stderr, "%s: get window size: %s\n", prgname, strerror(errno));
	exit(1);
    }
    buf = malloc(xsize*ysize);
    if (!buf) {
	fprintf(stderr,"%s: malloc(): %s\n", prgname, strerror(errno));
        exit(1);
    }
    xstep = (double)xsize/win.ws_col;
    ystep = (double)ysize/(win.ws_row-1);

    setvbuf(stdout, NULL, _IONBF, 0);

    while(1) {
	fseek(f, 0, SEEK_SET);
	fgets(s, 80, f); /* skip pgm header */
	if (fread(buf, 1, xsize * ysize, f) != xsize * ysize) {
	    fprintf(stderr,"%s: %s: read(): %s\n", prgname, devname,
		    strerror(errno));
	    exit(1);
	}
	for (y=0; y < win.ws_row-1; y++) {
	    printf("\x1b[%03i;001H",y+1); /* ugly */
	    Y=y*ystep;
	    for (x=0; x < win.ws_col; x++) {
		X=x*xstep;
		putchar(alpha[buf[X+Y*xsize]>>5]);
	    }
	}
	printf("\x1b[%03i;001H",y+1); /* ugly */
	printf("iteration %4i", count++);

    }
    return 0; /* never */
}



