#include <fcntl.h>
#include <sys/ioctl.h>
#include <asm/ioctl.h>
#include <asm/types.h>
#include <stdio.h>
#include <unistd.h>

#include "nicts.h"

int gpc, gpc1;

void readcts(void)
{
  unsigned long cnt;
  if(read(gpc, &cnt, 4)<4){
    perror("cant read gpc"); exit(2);}
  printf("pulse: %8ld\n",cnt);
}

int main(int argc, char *argv[])
{

  if(argc!=3){printf("usage!\n"); exit(1);}

  if((gpc=open(argv[1],O_RDWR))<0){
    perror("cant open first"); exit(1);}
  if((gpc1=open(argv[2],O_RDWR))<0){
    perror("cant open second"); exit(1);}
  /*
  ioctl(gpc, NICTL_GPCT_RESET, 0);
  ioctl(gpc, NICTL_GPCT_APP_PULSE_TRAIN, 0);
  ioctl(gpc, NICTL_GPCT_GATE_SEL, 6);
  ioctl(gpc, NICTL_GPCT_SET_CNT1, 1000-1);
  ioctl(gpc, NICTL_GPCT_SET_CNT2, 2000-1);
  ioctl(gpc, NICTL_GPCT_PREPARE, 0);
  ioctl(gpc, NICTL_GPCT_ARM, 0);
  */
  ioctl(gpc, NICTL_GPCT_RESET, 0);
  ioctl(gpc, NICTL_GPCT_APP_PULSE_TRAIN, 0);
  ioctl(gpc, NICTL_GPCT_GATE_SEL, 6);
  ioctl(gpc, NICTL_GPCT_SET_CNT1, (1<<24)-1);
  ioctl(gpc, NICTL_GPCT_SET_CNT2, (1<<24)-1);
  ioctl(gpc, NICTL_GPCT_PREPARE, 0);
  ioctl(gpc, NICTL_GPCT_ARM, 0);

  ioctl(gpc1, NICTL_GPCT_RESET, 0);
  ioctl(gpc1, NICTL_GPCT_APP_PULSE_TRIG, 0);
  ioctl(gpc1, NICTL_GPCT_GATE_SEL, 6);
  ioctl(gpc1, NICTL_GPCT_SET_CNT1, (1<<24)-1);
  ioctl(gpc1, NICTL_GPCT_PREPARE, 0);
  ioctl(gpc1, NICTL_GPCT_ARM, 0);

  close(gpc);
  close(gpc1);

  return 0;
}
