#include <fcntl.h>
#include <sys/ioctl.h>
#include <asm/ioctl.h>
#include <asm/types.h>
#include <stdio.h>
#include <unistd.h>

#include "nicts.h"

int main(int argc, char *argv[])
{
  int gpc, gpc1, dio, i, x;
  unsigned long cnt;
  unsigned short dout;

  if(argc!=3){printf("usage!\n"); exit(1);}

  if((gpc=open(argv[1],O_RDWR))<0){
    perror("cant open first"); exit(1);}
  if((gpc1=open(argv[2],O_RDWR))<0){
    perror("cant open second"); exit(1);}

  if((dio=open("/dev/nidio0",O_RDWR))<0){
    perror("cant open nigpct"); exit(1);}


  ioctl(dio, NICTL_DIO_CONFPORT, 0x03); /* DIO 0&1 is output */
  /* in my setup DIO1 is conn. to gpct1 gate
     gpct0 src can pe conn. to DIO0 or to gpct1 OUT
  */


  /* configure gpct 0 for event counting */
  ioctl(gpc, NICTL_GPCT_RESET, 0);
  ioctl(gpc, NICTL_GPCT_APP_EVENT_CNT, 0);

  ioctl(gpc, NICTL_GPCT_GATE_SEL, 31);
  ioctl(gpc, NICTL_GPCT_GATE_POL, 1);
  ioctl(gpc, NICTL_GPCT_SRC_SEL, 5); /* PFI 4 */
  ioctl(gpc, NICTL_GPCT_UP_DOWN, 1);
  ioctl(gpc, NICTL_GPCT_PREPARE, 0);
  ioctl(gpc, NICTL_GPCT_ARM, 0);
 

  /* configure gpct 1 for pulse train gen */

  ioctl(gpc1, NICTL_GPCT_RESET, 0);
  ioctl(gpc1, NICTL_GPCT_APP_PULSE_TRAIN, 0);
  ioctl(gpc1, NICTL_GPCT_SET_CNT1, 5000-1);
  ioctl(gpc1, NICTL_GPCT_SET_CNT2, 4000-1);
  ioctl(gpc1, NICTL_GPCT_SET_CNT3, 3000-1);

  ioctl(gpc1, NICTL_GPCT_PREPARE, 0);
  ioctl(gpc1, NICTL_GPCT_ARM, 0);

  dout=0;write(dio, &dout, 2);
  dout=2;write(dio, &dout, 2);

  x=0;
  while(1){
    for(i=0;i<x;i++){
      dout=1;write(dio, &dout,2);
      dout=0;write(dio, &dout,2);
    }
    x++; if(x==10)x=0;
    if(ioctl(gpc, NICTL_GPCT_READ, &cnt)<0){
       perror("cant read"); exit(2);}
    printf("%8ld\n",cnt);
    sleep(1);
  }

  close(gpc);

  return 0;
}
