#include <fcntl.h>
#include <sys/ioctl.h>
#include <asm/ioctl.h>
#include <asm/types.h>
#include <errno.h>
#include <stdio.h>
#include <unistd.h>

#include "nicts.h"

int gpc, gpc1;

int readcts(unsigned long *x)
{
  unsigned long cnt;
  if(read(gpc, &cnt, 4)<4){
    if(errno==EAGAIN) return -1;
    perror("cant read gpc"); exit(2);
  }
  *x=cnt;
  /* printf("pulse: %8ld\n",cnt); */
  return 0;
}

int main(int argc, char *argv[])
{
  int i, perhi, perlo, reads=10;
  unsigned long cnt;

  if(argc!=3){printf("usage! ctmeas ctpulse\n"); exit(1);}
  
  if((gpc=open(argv[1],O_RDWR))<0){
    perror("cant open first ctr"); exit(1);}
  if((gpc1=open(argv[2],O_RDWR))<0){
    perror("cant open second ctr"); exit(1);}

  for(perhi=5000; perhi>=500; perhi-=250){
    perlo=perhi-100;
    /* configure gpct 0 for buff period meas */
    ioctl(gpc, NICTL_GPCT_RESET, 0);
    ioctl(gpc1, NICTL_GPCT_RESET, 0);

    ioctl(gpc, NICTL_GPCT_APP_BUF_PW_MEAS, 0); 
    ioctl(gpc, NICTL_GPCT_GATE_SEL, 6); /* PFI 5 */
    ioctl(gpc, NICTL_GPCT_GATE_POL, 0);
    ioctl(gpc, NICTL_GPCT_SET_NPTS, reads);
    ioctl(gpc, NICTL_GPCT_PREPARE, 0);
 
    ioctl(gpc1, NICTL_GPCT_RESET, 0);
    ioctl(gpc1, NICTL_GPCT_APP_PULSE_TRAIN, 0);
    ioctl(gpc1, NICTL_GPCT_SET_CNT1, perlo);
    ioctl(gpc1, NICTL_GPCT_SET_CNT2, perhi);
    ioctl(gpc1, NICTL_GPCT_SET_CNT3, 5000);
    ioctl(gpc1, NICTL_GPCT_PREPARE, 0);

    ioctl(gpc, NICTL_GPCT_ARM, 0);
    ioctl(gpc1, NICTL_GPCT_ARM, 0);
    /* the first period >40000 because gp0 & gp1 are not simult. armed */

    printf("testing per=%d...\n",perhi);
    for(i=0;i<reads;i++) {
      while(readcts(&cnt)<0);
      printf("%d %ld\n",i, cnt);
    }
  }
  close(gpc); close(gpc1);

  return 0;
}





