/* Takes a double voltage from the command line, and writes 
   that value to both DAC0 and DAC1
   of a AO capable device

usage: ./testao <device#> <voltage>
sample: ./testao 1 5.0 

*/

#include <stdio.h>
#include <stdlib.h>
#include <nidaq.h>

int main(int argc, char *argv[])
{
  int dev_handle;
  double volt;

  if (argc < 3)
    {
      printf ("Usage: %s <device> <voltage>\n",argv[0]); 
      return 1;
    }

  // device numbers are 1-based, don't forget that!
  volt = atof (argv[2]);
  dev_handle = LxAoOpen (atoi(argv[1]));

  if (dev_handle < 0)
    {
      perror("can't open that file"); 
      exit(1);
    }
 
  LxAoUpdateChannel (dev_handle, 0, volt);
  LxAoUpdateChannel (dev_handle, 0, volt);

  return 0;
}










