/* Reads nscans (default 10) of nch channels (default 4) from an AI capable
device. The interval between scans is siper (default 20000 -> 1kS/s) and
the interval between samples inside a scan is si2per (default 100 -> 200kS/s)

Converts data read from short to double (assuming 12 bit resolution, bipolar
mode and gain=0.5) and displays it, one scan on a raw

Feel free to modify nscans, nch (and the channel list, default 0,1,2,3),
siper and si2per.

usage: ./testai <device>
sample: ./testai /dev/nidaq0

*/

#include <fcntl.h>
#include <asm/ioctl.h>
#include <asm/types.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <unistd.h>

#include "nicts.h"

int main(int argc, char *argv[])
{
  int daq,nr;
  short valin[100000];

  int nscans=10, nch=4, siper=20000, si2per=100, i; 

  if(argc<2){printf("usage !\n"); return 1;}
  if((daq=open(argv[1],O_RDWR))<0){
    perror("cant open that file"); exit(1);}
  
  ioctl(daq, NICTL_AI_RESET, 0);

  if(nch>3) ioctl(daq, NICTL_AI_ADDCH, 0x10000000);
  if(nch>2) ioctl(daq, NICTL_AI_ADDCH, 0x10010000);
  if(nch>1) ioctl(daq, NICTL_AI_ADDCH, 0x10020000);
  ioctl          (daq, NICTL_AI_ADDCH, 0x10038000);
  
  ioctl(daq, NICTL_AI_SET_SC, nscans-1);
  ioctl(daq, NICTL_AI_SET_SI, siper-1);
  ioctl(daq, NICTL_AI_SET_SI2,si2per-1);
  
  ioctl(daq, NICTL_AI_SCAN_SETUP, 0);
  ioctl(daq, NICTL_AI_SCAN_START, 0);
    
  if((nr=read(daq, valin, nscans*2*nch))<0){
    perror("cant read nidaq"); exit(2);}
    
  printf("samples read: %d\n",nr/2);
  for(i=0;i<nr/2;i++){
    printf("%5.2f ",valin[i]*10.0/2048);
    if(i%nch==nch-1)printf("\n");
  }
  close(daq);

  return 0;
}










