#include <dlfcn.h>
#include <asm/types.h>
#include <stdio.h>

#include "nicts.h"
#include "extcode.h"

CIN MgErr CINRun(int32 *task_id_in, int32 *status);
void *nilib;
int (*LxAiClear)(__s32 fh);

CIN MgErr CINLoad (RsrcFile reserved)
{
  nilib=dlopen("/usr/lib/libnidaq.so",RTLD_LAZY);  
  if(!nilib)return -1;
  LxAiClear=dlsym(nilib, "LxAiClear"); if(dlerror()!=NULL)return -1;
  return noErr;
}

CIN MgErr CINUnload ()
{
  if(nilib)dlclose(nilib);
  return noErr;
}

CIN MgErr CINRun(int32 *task_id_in, int32 *status) 
{
  int fh;
  fh=*task_id_in;
  if((*status=(*LxAiClear)(fh))<0) return noErr;

  *status=0;
  return noErr;
}
