#include <sys/ioctl.h>
#include <asm/ioctl.h>
#include <asm/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>

#include "../driver/nicts.h"
#include "nidaq.h"

static int gpcth[NI_MAX_BOARDS][2];

int LxGpctOpen(__u16 device, __u16 counter_no)
{
  char fname[20];

  if(device<1 || device>NI_MAX_BOARDS ||  counter_no>1) return -1;
  if(gpcth[device-1][counter_no]>0)close(gpcth[device-1][counter_no]);
  sprintf(fname,"/dev/nigpct%d%d",device-1,counter_no);
  gpcth[device-1][counter_no]=open(fname,O_RDWR);
  return gpcth[device-1][counter_no];
}

int LxGpctCloseAll(void)
{
  int i,j;
  for(i=0;i<NI_MAX_BOARDS;i++)for(j=0;j<2;j++)
    if(gpcth[i][j]>0)close(gpcth[i][j]);
  return 0;
}

int LxGpctSetapp(__s32 fh, __s16 function)
{
  switch(function){
  case 1: /* event count */
    ioctl( fh, NICTL_GPCT_APP_EVENT_CNT, 0);
    break;
  case 2: /* period measurement */
    ioctl(fh, NICTL_GPCT_APP_PER_MEAS, 0);
    break;
  case 3: case 4: /* pw meas & trg. pw meas */
    ioctl(fh, NICTL_GPCT_APP_PW_MEAS, 0);
    break;
  case 5: /* 1 pulse gen */
    ioctl(fh, NICTL_GPCT_APP_PULSE, 0);
    break;
  case 6: /* 1 trig pulse gen */
    ioctl(fh, NICTL_GPCT_APP_PULSE_TRIG, 0);
    break;
  case 7: /* retrig pulse gen */
    ioctl(fh, NICTL_GPCT_APP_PULSE_RETRIG, 0);
    break;
  case 8: /* pulse train gen */
    ioctl(fh, NICTL_GPCT_APP_PULSE_TRAIN, 0);
    break;
  case 9: /* FSK */
    break;
  case 10: /* buff ev count */
    break;
  case 11: /* buff per meas */
    break;
  case 12: /* buff semiper meas */
    break;
  case 13: /*buff pw meas */
    break;
  }
  return 0;
}

int LxGpctSetpar(__s32 fh, __s16 param, __u32 value)
{
  switch(param){
  case 1: ioctl(fh, NICTL_GPCT_SRC_SEL, value); break;
  case 2: ioctl(fh, NICTL_GPCT_SRC_POL, value); break;
  case 3: ioctl(fh, NICTL_GPCT_GATE_SEL, value); break;
  case 4:  ioctl(fh, NICTL_GPCT_GATE_POL, value); break;
  /* icnt not yet in the driver */
  case 6: ioctl(fh, NICTL_GPCT_SET_CNT1, value); break;
  case 7: ioctl(fh, NICTL_GPCT_SET_CNT2, value); break;
  case 8: ioctl(fh, NICTL_GPCT_SET_CNT3, value); break;
  case 9: ioctl(fh, NICTL_GPCT_SET_CNT4, value); break;
  /* auto-inc not yet in the driver */
  case 11: ioctl(fh, NICTL_GPCT_UP_DOWN, value); break;
  case 12: ioctl(fh, NICTL_GPCT_OUT_MODE, value); break;
  case 13: ioctl(fh,NICTL_GPCT_OUT_POL, value); break;
  }
  return 0;
}

int LxGpctControl(__s32 fh, __s16 function)
{
  switch(function){
  case 1: /* reset */
    ioctl(fh, NICTL_GPCT_RESET, 0);
    break;
  case 2:  /* prepare */
    ioctl(fh, NICTL_GPCT_PREPARE, 0);
    break;
  case 3:  /* arm */
    ioctl(fh, NICTL_GPCT_ARM, 0);
    break;
  case 4: /* program */
    ioctl(fh, NICTL_GPCT_PREPARE, 0);
    ioctl(fh, NICTL_GPCT_ARM, 0);
    break;
  case 5: /* count up */
    break;
  case 6: /* count down */
    break;
  case 7: /* disarm */
    ioctl(fh, NICTL_GPCT_DISARM, 0);
    break;
  }
  return 0;
}

int LxGpctWatch(__s32 fh, __s16 function, __u32 *result)
{
   switch(function){
  case 1: /* count? */
    ioctl(fh, NICTL_GPCT_READ, result);
    break;
  case 2: /* armed? */
    ioctl(fh, NICTL_GPCT_ARMED, result);
    break;
  case 3: /* tc reached? */
    break;
  case 4: /* pulse done? */
    break;
  case 5: /* out state? */
    break;
  case 6: /* count avail.?*/
    break;
  case 7: /* avail. points */
    break;
  }

  return 0;
}


