#define SUBDEV_AIO 0
#define SUBDEV_DIO 1
#define SUBDEV_GPCT0 2
#define SUBDEV_GPCT1 3
#define SUBDEV_STATS 4

#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif
#include "nicts.h"

// set up our define for Linux 2.1.x or higher
#include <linux/version.h>
#if LINUX_VERSION_CODE > 0x020100
#define LINUX_2_1
#endif

// now set up a few function defines that changed in Linux 2.1.x
#ifndef LINUX_2_1
#define ioremap vremap
#define iounmap vfree
#define copy_from_user memcpy_fromfs
#define copy_to_user memcpy_tofs
#endif

#ifdef LINUX_2_1
#include <asm/uaccess.h>
#endif

extern device_info *device_info_list;
device_info *dev_info_by_type(u32 type);
device_info *dev_info_by_deviceid(u16 dev_id);
void init_device_info_list(void);

#define AIBUFFSIZE 10000
#define AOBUFFSIZE 10000
#define GPCTBUFFSIZE 1000

typedef  struct {
  u16 src_sel, src_pol, gate_sel, gate_pol, out_mode, out_pol, up_down;
  u32 icnt, cnt1, cnt2, cnt3, cnt4;
  u32 *buff, pread, pwrite, pts_read, tot_pts;
  s32 mode, g_buff_done, gate_error, rollover, fifo_overflow;
  
  struct wait_queue *wait_queue;

} gpct_private_data;

typedef struct {

  device_info *dev_info;

  u32 base, virt_mite, io_region_size, type;
  s16 irq, irq_pin, dma1, dma2, pci_slot;

  u16 stccpy[256];

  u16 ai_in_use, ao_in_use, dio_in_use;

  u16 ai_running, ai_FIFO_oflow,ai_BUFF_oflow, ai_si2, ao_ch;
  u16 aiuStatus, aouStatus;
  u32 ai_si, ai_sc, no_of_interrupts, ai_points_read, ai_pwrite, ai_pread;

  u16 dio_current_port, dio_write_mask;
  u8 dio_ppicpy[4], dio_wrcpy[12];

  gpct_private_data gc[2];

  u16 *aibuff, *aobuff;

  struct wait_queue *ai_wait_queue;

} ni_private_data, *pd;

extern ni_private_data ni_pd[];


void DAQ_STC_Windowed_Mode_Write_Byte(pd dev, u32 uRegister_Address, u8 uData);
void DAQ_STC_Windowed_Mode_Write(pd dev, u32 uRegister_Address, u16 uData);
void DAQ_STC_Windowed_Mode_Masked_Write(pd dev, u32 uRegister_Address, u16 uData, u16 mask);
void DAQ_STC_Windowed_Mode_Strobe_Write(pd dev, u32 uRegister_Address, u16 uData);

u8 DAQ_STC_Windowed_Mode_Read_Byte(pd dev, u32 uRegister_Address);
u16 DAQ_STC_Windowed_Mode_Read(pd dev, u32 uRegister_Address);


void Board_Write(pd dev, u32 uRegister_Address, u16 uData);
void Board_Write_Byte(pd dev, u32 uRegister_Address, u8 uData);

u16 Board_Read(pd dev, u32 uRegister_Address);
u8 Board_Read_Byte(pd dev, u32 uRegister_Address);

int loadcalibration(pd dev);
