#include <nidaq.h>
#include <stdio.h>

int main (int argc, char *argv[])
{
  __u16 device;
  __u16 channel;
  int dev_handle;
  __u16 gain = 1;       // gain of 1x
  __u16 polarity = 0;   // bipolar mode
  __u16 ref = 0;        // differential mode
  __s16 result;
  float fresult;

  if (argc != 3)
    {
      printf ("Usage:  %s <device#> <channel#>", argv[0]);
      exit (1);
    }

  device = atoi (argv[1]);
  channel = atoi (argv[2]);

  dev_handle = LxAiOpen (device);
  if (dev_handle < 0)
    {
      perror ("Couldn't open DAQ device");
      exit (1);
    }

  LxAiBoardConfig (dev_handle, 1, &channel, &gain, &polarity, &ref);
  LxAiSingleScan (dev_handle, &result);
  LxAiScale (dev_handle, 1, &result, &fresult);

  printf ("%6.3f\n", fresult);

  exit (0);
}

