#include <dlfcn.h>
#include <asm/types.h>
#include <stdio.h>

#include "nicts.h"
#include "extcode.h"

void *nilib;
int (*LxGpctSetpar)(__s32 fh, __s16 param, __u32 value);

CIN MgErr CINRun(int16 *source_sel, LVBoolean *source_pol, int16 *gate_sel, LVBoolean *gate_pol, uInt32 *init_cnt, uInt32 *cnt1, uInt32 *cnt2, uInt32 *cnt3, uInt32 *cnt4, int16 *auto_inc, LVBoolean *up_down, int16 *out_mode, LVBoolean *outp_pol, int32 *tid_in, int32 *status);

CIN MgErr CINLoad (RsrcFile reserved)
{

  nilib=dlopen("/usr/lib/libnidaq.so",RTLD_LAZY);  
  if(!nilib)return -1;
  LxGpctSetpar=dlsym(nilib, "LxGpctSetpar"); if(dlerror()!=NULL)return -1;
  return noErr;
}

CIN MgErr CINUnload ()
{

  if(nilib)dlclose(nilib);
  return noErr;
}

CIN MgErr CINRun(int16 *source_sel, LVBoolean *source_pol, int16 *gate_sel, LVBoolean *gate_pol, uInt32 *init_cnt, uInt32 *cnt1, uInt32 *cnt2, uInt32 *cnt3, uInt32 *cnt4, int16 *auto_inc, LVBoolean *up_down, int16 *out_mode, LVBoolean *outp_pol, int32 *tid_in, int32 *status) {

  int fh=*tid_in;
  *status=0;
  
  (*LxGpctSetpar)(fh, 1, *source_sel);
  (*LxGpctSetpar)(fh, 2, *source_pol);
  (*LxGpctSetpar)(fh, 3, *gate_sel);
  (*LxGpctSetpar)(fh, 4, *gate_pol);
  (*LxGpctSetpar)(fh, 5, *init_cnt);
  (*LxGpctSetpar)(fh, 6, *cnt1);
  (*LxGpctSetpar)(fh, 7, *cnt2);
  (*LxGpctSetpar)(fh, 8, *cnt3);
  (*LxGpctSetpar)(fh, 9, *cnt4);
  (*LxGpctSetpar)(fh, 10, *auto_inc);
  (*LxGpctSetpar)(fh, 11, *up_down);
  (*LxGpctSetpar)(fh, 12, *out_mode);
  (*LxGpctSetpar)(fh, 13, *outp_pol);

  return noErr;
}



