#include <dlfcn.h>
#include <asm/types.h>
#include <stdio.h>

#include "nicts.h"
#include "extcode.h"

CIN MgErr CINRun(uInt16 *device, uInt16 *counter, int16 *function, int32 *tid_in, int32 *status);

void *nilib;
int (*LxGpctControl)(__s32 fh, __s16 function);
int (*LxGpctOpen)(__u16 device, __u16 counter_no);
int (*LxGpctCloseAll)();

CIN MgErr CINLoad (RsrcFile reserved)
{
  nilib=dlopen("/usr/lib/libnidaq.so",RTLD_LAZY);  
  if(!nilib)return -1;
  LxGpctControl=dlsym(nilib, "LxGpctControl"); if(dlerror()!=NULL)return -1;
  LxGpctOpen=dlsym(nilib, "LxGpctOpen"); if(dlerror()!=NULL)return -1;
  LxGpctCloseAll=dlsym(nilib, "LxGpctCloseAll"); if(dlerror()!=NULL)return -1;
  return noErr;
}

CIN MgErr CINUnload ()
{
  if(nilib){(*LxGpctCloseAll)();dlclose(nilib);}
  return noErr;
}

CIN MgErr CINRun(uInt16 *device, uInt16 *counter, int16 *function, int32 *tid_in, int32 *status) {

  int fh;

  if((*function==1)&&(*device)){ /* device is used when reset and device!=0 */
    fh = *tid_in = (*LxGpctOpen)(*device, *counter);
  } else fh=*tid_in;
  if(fh<0){*status=fh; return noErr;}
  *status=0;

  (*LxGpctControl)(fh, *function);
 
  return noErr;
}


