#include <sys/ioctl.h>
#include <asm/ioctl.h>
#include <asm/types.h>
#include <fcntl.h>
#include <unistd.h>

#include <stdio.h>

#include "../driver/nicts.h"
#include "nidaq.h"

static int dioh[NI_MAX_BOARDS];

int LxDioOpen(__u16 device)
{
  char fname[20];

  if(device<1 || device>NI_MAX_BOARDS) return -1;
  if(dioh[device-1]>0)close(dioh[device-1]);
  sprintf(fname,"/dev/nidio%d",device-1);
  dioh[device-1]=open(fname,O_RDWR);
  return dioh[device-1];
}

int LxDioCloseAll(void)
{
  int i;
  for(i=0;i<NI_MAX_BOARDS;i++)if(dioh[i]>0)close(dioh[i]);
  return 0;
}

int LxDioConfPort(__s32 fh, __u16 port, __u32 rw_mask)
{
  ioctl(fh, NICTL_DIO_SELPORT, (__u32)port);
  ioctl(fh, NICTL_DIO_CONFPORT, rw_mask);
  return 0;
}

int LxDioWrite(__s32 fh, __u16 port, __u32 wr_data, __u32 wr_mask)
{
  __u8 d8=wr_data;

  ioctl(fh, NICTL_DIO_SELPORT, (__u32)port);
  ioctl(fh, NICTL_DIO_WRMASK, wr_mask);
  if(write(fh, &d8, 1)<1) return -10001;
  return 0;
}

int LxDioRead(__s32 fh, __u16 port, __u32 *read_data)
{
  __u8 d8;

  ioctl(fh, NICTL_DIO_SELPORT, (__u32)port);
  if(read(fh, &d8, 1)<1) return -10001;
  *read_data=d8;
  return 0;
}
