#!/usr/bin/perl

open (IN, "</proc/devices") || die "can't open /proc/devices";

while (<IN>){
    ($major)=/(\d+)\snidaq/;
    last if $major;
    }
close IN;

$major || die "can't find nidaq device";

print " ... making nidaq device files using major=$major\n";

&mkdevs(0);
&mkdevs(1);
&mkdevs(2);
&mkdevs(3);


exit 0;

sub mkchardev {
    ($name, $minor)=@_;

    $name="/dev/".$name;
    
    `rm -f $name`;
    `mknod $name c $major $minor`;
    `chmod a+rw $name`;

}

sub mkdevs {
    ($brdno)=@_;

    &mkchardev("nidaq$brdno", 0+$brdno*16);
    &mkchardev("nidio$brdno", 1+$brdno*16);
    &mkchardev("nigpct$brdno"."0", 2+$brdno*16);
    &mkchardev("nigpct$brdno"."1", 3+$brdno*16);
    &mkchardev("nistats$brdno",4+$brdno*16);

}


