#include <linux/sched.h>

#include "eserrlp.h"
#include "daq_driver.h"
#include "misc.h"

void MSC_Clock_Configure(pd dev)
{ 
  /*
  * Writing to register Clock_and_FOUT_Register with address 56.
  *    Slow_Internal_Timebase <= p->msc_slow_int_tb_enable (1)
  *    Slow_Internal_Time_Divide_By_2 <= p->msc_slow_int_tb_divide_by_2 (1)
  *    Clock_To_Board <= p->msc_clock_to_board_enable (1)
  *    Clock_To_Board_Divide_By_2 <= p->msc_clock_to_board_divide_by_2 (1)
  * New pattern = 0x1B00
  */
  DAQ_STC_Windowed_Mode_Write(dev, Clock_and_FOUT_Register,0x1B00);
 
}  

void MSC_IO_Pin_Configure(pd dev){
/*      Writing to IO_Bidirection_Pin_Register with address 57
 *      BD_0_Pin_Dir <= 0
 *      pattern = 0x0000 set PFI(0-9) for input
 */
  DAQ_STC_Windowed_Mode_Write(dev, IO_Bidirection_Pin_Register,0x0000);
}

void MSC_IrqGroupEnable(pd dev, int grp) /* 0=A, 1=B */
{

  /* schedule() introduce delays which prevent (some) PXI systems to hang.
     I've tested no such system so I can't say which of them do it :-) */

  if(dev->irq == -1) return ; /* don't try to enable interrupts */

  if (dev->type & NI_PCI)  {
    schedule();
    DAQ_STC_Windowed_Mode_Masked_Write (dev, Interrupt_Control_Register,
					0x0001, 0x0001);
  }

  if(!grp){ /* irq grp A */
    /*
     * Writing to register Interrupt_Control_Register with address 59.
     *    Interrupt_A_Output_Select <= p->msc_irq_pin[irq_group] (4)  
     */
    schedule();
    DAQ_STC_Windowed_Mode_Masked_Write(dev, Interrupt_Control_Register,
				       (dev->irq_pin<<8), 0x0700);
    /* 
     * Writing to register Interrupt_Control_Register with address 59.
     *    Interrupt_A_Enable <= p->msc_irq_enable[irq_group] (1)
     */
    schedule ();
    DAQ_STC_Windowed_Mode_Masked_Write(dev, Interrupt_Control_Register,
				       0x0800,0x0800);
  } else { /* IRQ group B */
    schedule();
    DAQ_STC_Windowed_Mode_Masked_Write(dev, Interrupt_Control_Register,
				       (dev->irq_pin<<12), 0x7000);
    schedule();
    DAQ_STC_Windowed_Mode_Masked_Write(dev, Interrupt_Control_Register,
				       0x8000,0x8000);
  }
}
