#include <linux/fs.h>

#include "eserrlp.h"
#include "daq_driver.h"

#ifdef LINUX_2_1
/* sometimes I wish the Linux kernel were API stable... (*sigh*)

   The definition of get_user changed in the 2.1.x kernel.  Now
   it takes *two* arguments, but because of the fun fact that it's
   a macro, this isn't easily corrected.  Rather than hack up the
   code below, I'm taking the liberty of redefining get_user to
   only take one argument.  Since it's just confined to this .c file
   no one should throw a hissy.  */
#undef get_user
#define get_user(ptr)                                                    \
({    int __ret_gu, __val_gu;                                            \
      switch (sizeof (*(ptr)))  {                                        \
        case 1: __get_user_x(1,__ret_gu,__val_gu,ptr); break;            \
        case 2: __get_user_x(2,__ret_gu,__val_gu,ptr); break;            \
        case 4: __get_user_x(4,__ret_gu,__val_gu,ptr); break;            \
        default: __get_user_x(X,__ret_gu,__val_gu,ptr); break; }         \
      __ret_gu;                                                          \
})
#endif /* LINUX_2_1 */

int dio_read(pd dev, struct file * file, char * buf, int count)
{ 
  int i, ppi, port;
  unsigned char uPattern=0;

  for(i=0;i<count;i++){
    if(dev->type&NI_ESER && !dev->dio_current_port)
      uPattern = DAQ_STC_Windowed_Mode_Read(dev, DIO_Parallel_Input_Register);
    else if(dev->type&NI_8255)
      if(dev->type&NI_ESER){
	port=dev->dio_current_port-1; ppi=0;
	uPattern=Board_Read_Byte(dev, 0x19 + port*2);
      } else {
	ppi= dev->dio_current_port/3; port=dev->dio_current_port%3;
	uPattern=Board_Read_Byte(dev, ppi*4+port);    
      }
    put_user(uPattern,buf++);
  }
  return count;
}

int dio_write(pd dev, struct file * file, char const * buf, int count)
{ 
  int i, ppi, port;
  u8 uPattern;

  for(i=0;i<count;i++){
    uPattern=(get_user(buf++)&dev->dio_write_mask) |
      (dev->dio_wrcpy[dev->dio_current_port]&~dev->dio_write_mask);
    dev->dio_wrcpy[dev->dio_current_port]=uPattern;

    if(dev->type&NI_ESER && !dev->dio_current_port)
      DAQ_STC_Windowed_Mode_Write(dev, DIO_Output_Register, uPattern);
    else if (dev->type&NI_8255)
      if(dev->type&NI_ESER){
	port=dev->dio_current_port-1; ppi=0;
	Board_Write_Byte(dev, 0x19 + port*2, uPattern);
      } else {
	ppi= dev->dio_current_port/3; port=dev->dio_current_port%3;
	Board_Write_Byte(dev, ppi*4+port, uPattern);    
      }
  }
  return count;    
}

int dio_ioctl(pd dev, struct file *file, unsigned int cmd, unsigned long arg)
{
  int ppi, port;
  u16 mask;

  switch(_IOC_NR(cmd)){
  case _IOC_NR(NICTL_DIO_SELPORT):
    dev->dio_current_port=arg;
    return 0;
  case _IOC_NR(NICTL_DIO_WRMASK):
    dev->dio_write_mask=arg;
    return 0;
  case _IOC_NR(NICTL_DIO_CONFPORT):
    if(dev->type&NI_ESER && !dev->dio_current_port)
      DAQ_STC_Windowed_Mode_Write(dev, DIO_Control_Register, arg&0xff);

    else if(dev->type&NI_8255){
      if(dev->type&NI_ESER){
	port=dev->dio_current_port-1; ppi=0;}
      else {
	ppi= dev->dio_current_port/3; port=dev->dio_current_port%3;
      }
      mask=!port?0x10:port==1?0x02:0x09;
      if(arg)dev->dio_ppicpy[ppi]&=~mask; else dev->dio_ppicpy[ppi]|=mask;
      if(dev->type&NI_ESER) 
	Board_Write_Byte(dev, 0x1F, dev->dio_ppicpy[ppi]);
      else
	Board_Write_Byte(dev, 3+ppi*4, dev->dio_ppicpy[ppi]);
    }
    return 0;
  }
  return -EINVAL;
}

int dio_open(pd dev, struct file * file){
  int i, nports, nppis;

  dev->dio_current_port=0;
  dev->dio_write_mask=0;

  if(dev->type&NI_ESER)
    DAQ_STC_Windowed_Mode_Write(dev, DIO_Control_Register, 0x00); /* all IN */

  if(dev->type&NI_8255){
    for(i=0;i<12;i++)dev->dio_wrcpy[i]=0;
    if(dev->type&NI_ESER){
      dev->dio_ppicpy[0]=0x9B;
      Board_Write_Byte(dev, 0x1F, 0x9B);
    } else {
      nports=dev->dev_info->dioports;
      nppis=nports/3;
      for(i=0;i<nppis;i++){
	dev->dio_ppicpy[i]=0x9B;
	Board_Write_Byte(dev, 3+i*4, 0x9B); /* all ports input */
      }
    }
  }
  return 0;
}

