#include <linux/fs.h>
#include "daq_driver.h"

device_info *device_info_list;

static void additem(device_info *dinfo)
{
  dinfo->next=device_info_list;
  device_info_list=dinfo;
}

device_info *dev_info_by_type(u32 type)
{
  device_info *p=device_info_list;
  while(p)if(p->type==type) return p; else p=p->next;
  return NULL;
}

device_info *dev_info_by_deviceid(u16 dev_id)
{
  device_info *p=device_info_list;
  while(p)if(p->device_id==dev_id)return p; else p=p->next;
  return NULL;
}

#include "device_info.h"


