/* *******************************************************************
 * Distinct ONC RPC/XDR for Java
 * Copyright 1997, 1998 by Distinct Corporation. All rights reserved.
 *********************************************************************/

import java.applet.*;
import java.awt.*;
import java.net.*;
import distinct.rpc.*;

public class testapp extends Applet {

    cou client;     // RPC client object
    String buffer;

    public void start () {
        buffer = new String();
        try {
            client = new cou (InetAddress.getByName (   // create a new connection to the server
                getDocumentBase().getHost()),           // on the host where this applet came from
                true);                                  // use TCP
        }
        catch (Exception e) {   // an error happened
            printStr (e.getMessage ());
            client = null;
            return;
        };
        printStr ("Connected to counter server");
    }

    public void stop() {
        if (client != null)
            client.GetClient().close();                 // destroy the client and close the socket
        client = null;
    }

    public boolean mouseDown (Event evt, int x, int y) {
        if (client != null)
        try {
            int i = client.inc_1 ();                    // call it
                printStr ("RPC returns: " + i);
        }
        catch (Exception e) {                           // RPC error happened
            printStr (e.getMessage());    

            // close the client, subsequent calls may lead to undefined results
            // if you want to try it again, you better create a new client object
            stop ();
        };
        return true;
    }

    void printStr (String newWord) {
        buffer = newWord;
        repaint ();
    }

    public void paint (Graphics g) {
        g.drawRect (0, 0, size ().width - 1, size ().height - 1);
        g.drawString ("Any click in the applet will initiate one RPC to the counter server.", 5, 15);
        g.drawString (buffer, 5, 35);
    }
}
