import distinct.rpc.*;
import java.io.IOException;
import java.net.InetAddress;

/**
 * This class was automatically generated by Jrpcgen from the RPC/XDR file "cou.x" <br>.
 * It defines the client interface to a server implementing the "cou" interface.
 */

public class cou extends JRPCClient {

/** Program ID of the interface. */
public static final int COUNTSERV = 77;

/** Version of the interface. */
public static final int COUNTVERS = 1;

/**
 * Creates and connects an RPC client for a server that implements the "cou" interface.
 * Calls the remote Portmapper in order to get the port of the server.
 * @param host       The host on which the server lives.
 * @param stream     true for a TCP connection, false for UDP.
 * @exception        RPCError When the calls fails for any reason.
 */
public cou(InetAddress host, boolean stream) throws RPCError {
	super(host, COUNTSERV, COUNTVERS, stream);
}

/**
 * Creates and connects an RPC client for a server that implements the "cou" interface.
 * The client is connected it to a server with a known port. (No interaction with a portmapper)
 * @param host       The host on which the server lives.
 * @param port       The port on which the server listens.
 * @param stream     true for a TCP connection, false for UDP.
 * @exception        RPCError When the calls fails for any reason.
 */
public cou(InetAddress host, int port, boolean stream) throws RPCError {
	super(host, COUNTSERV, COUNTVERS, port, stream);
}

/**
 * Creates an RPC client for a server that implements the "cou" interface.
 * It initializes it with a externally created protocol client object.
 * @param protocol   The protocol object that implements the client connection.
 */
public cou(ClientGeneric protocol) {
	super(protocol);
}

public static final int inc = 1;

/**
 * Stub method that invokes the server function "inc" (version 1).
 */
public int inc_1() throws RPCError, IOException {
	XDRvoid arg_ref = new XDRvoid();

	XDRint retval = new XDRint();

	GetClient().Call(inc, arg_ref, retval);

	return retval.value;
}

public static final int dec = 2;

/**
 * Stub method that invokes the server function "dec" (version 1).
 */
public int dec_1() throws RPCError, IOException {
	XDRvoid arg_ref = new XDRvoid();

	XDRint retval = new XDRint();

	GetClient().Call(dec, arg_ref, retval);

	return retval.value;
}

public static final int set = 3;

/**
 * Stub method that invokes the server function "set" (version 1).
 */
public int set_1(int arg) throws RPCError, IOException {
	XDRint arg_ref = new XDRint();
	arg_ref.value = arg;

	XDRint retval = new XDRint();

	GetClient().Call(set, arg_ref, retval);

	return retval.value;
}
};
