/* *******************************************************************
 * Distinct ONC RPC/XDR for Java
 * Copyright 1997 - 1999 by Distinct Corporation. All rights reserved.
 *********************************************************************/

import distinct.rpc.*;

public class KeyGenerator {

    public static void main(String[] argv) {
        String passwd;

        if ((argv.length > 2) || (argv.length == 0)) {
            System.err.println("usage: KeyGenerator [<netname>] <password>");
            System.exit(-1);
        }

        if (argv.length == 1)
            passwd = argv[0];
        else
            passwd = argv[1];

        try {
            String keys = AuthDes.generateKeyPair(passwd);
            if (argv.length == 2)
                System.out.print(argv[0]+" ");
            System.out.println(keys);
            System.exit(0);
        }
        catch (RPCError e) {
            System.err.println(e.getMessage());
        }
        System.exit(-1);
    }
}
