/* *******************************************************************
 * Distinct ONC RPC/XDR for Java
 * Copyright 1997, 1998 by Distinct Corporation. All rights reserved.
 *********************************************************************/

import java.applet.*;
import java.awt.*;
import java.net.*;
import distinct.rpc.*;

class BroadcastImpl implements BroadcastHandler
{
    public boolean onReply (XDRType retval, InetAddress addr)
    {
        // reply is of type XDRvoid and does not contain data,
        // display IP address of responding server at this point
        System.out.println ("Found NFS server " + addr.getHostName () + " with IP address " + addr.getHostAddress ());

        // return false here to keep sending and receiving, or...
        return (true);      // quit after one reply
    }
}

public class BroadcastTest {
    // this sample uses broadcast RPC to find an NFS server
    public static void main (String args []) {
        XDRvoid myin;
        XDRvoid myout;
        BroadcastImpl BroadcastHnd = new BroadcastImpl ();

        myin = new XDRvoid ();
        myout = new XDRvoid ();

        // make UDP broadcast call to NFS servers (program number 100003)
        try {
            // procedure 0 is used to check if an NFS server is available,
            // it requires no argument and returns nothing (both XDRvoid)
            JRPCClient.BroadcastCall (100003, 2, 0, myin, myout, BroadcastHnd);
        }
        catch (Exception e) {
            System.out.println (e.getMessage ());
            System.exit (1); // broadcast call failed
        };
        System.exit (0); // success
    }
}
