/*********************************************************************
 * Distinct ONC RPC/XDR for Java
 * Copyright 1997, 1998 by Distinct Corporation. All rights reserved.
 *********************************************************************/

#define MAXREPLY 8800

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef WIN32
#include <windows.h>
#include <io.h>
#include <fcntl.h>
#include <d32-rpc.h>

typedef BOOL bool_t;
typedef char* caddr_t;
#else
#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>
#endif

static FILE *logfd;

#ifdef WIN32
void bcopy (char *s1, char *s2, int len) {
    for(; len > 0; len--) *s2++ = *s1++;
}
#endif

void error_exit(char *str, int arg) {
	printf("Content-type: text/html%c%c",10,10);
	printf(str, arg);
	if (logfd) {
		fprintf(logfd, "Error: ");
		fprintf(logfd, str, arg);
		fprintf(logfd, "\n");
	}
	exit(1);
}

static int input_len;

bool_t	xdr_in(XDR *xdrs, caddr_t cp) {
	return xdr_opaque(xdrs, cp, input_len);
}

static int output_len;
static int output_len_max;

bool_t	xdr_out(XDR *xdrs, caddr_t cp) {

	output_len = 0;
	while (output_len < output_len_max) {
		if (!xdr_opaque(xdrs, cp, 4))
			return TRUE;
		cp += 4;
		output_len += 4;
	}
	return TRUE;
}

void main(int argc, char *argv[]) {
    int secure, hit, clen, read, i, request_len, id, name_len;
	char *clstr, *request, *ip, *host, *prot;
	FILE *fd;
	char r_prog[256];
	char r_host[1024];
	char r_vers[256];
	char r_prot[256];
	char r_proc[256];
	long prog, vers, proc;
	long timeout_val;
	struct timeval call_timeout;
#ifdef WIN32
	HCLIENT *cl;
	int stat;
#else
	CLIENT *cl;
	enum clnt_stat stat;
#endif
	char reply[MAXREPLY];

#ifdef NO_SECURITY
	secure = FALSE;
#else
	secure = TRUE;
#endif

#ifdef DO_LOGGING
	logfd = fopen(LOGFILENAME, "a");
#else
	logfd = 0;
#endif

//	logfd = 0;
//	if (argv[0][0] == 'f') {
//		secure = FALSE;
//	} else if (argv[0][0] == 'l') {
//		logfd = fopen("rpcgw.log", "a");
//	}
   
	if (logfd != 0) {
		time_t ltime;

		time(&ltime);
		fprintf(logfd, "[%.24s] ", ctime(&ltime));
		if (getenv("REMOTE_HOST") != 0)
			fprintf(logfd, "%s ", getenv("REMOTE_HOST"));
		else if (getenv("REMOTE_ADDR") != 0)
			fprintf(logfd, "%s ", getenv("REMOTE_ADDR"));
	}

    if((clstr = getenv("REQUEST_METHOD")) && strcmp(clstr,"POST"))
        error_exit("Illegal request method.", 0);

    if ((clstr = getenv("CONTENT_LENGTH")) == 0)
		error_exit("Error in content decoding. No length parameter.", 0);

    if ((clen = atoi(clstr)) <= 0)
		error_exit("Error in content decoding. Length = %d.", clen);

	if ((request = malloc(clen)) == 0)
		error_exit("Error in memory allocation. Length = %d.", clen);

	if ((read = fread(request, 1, clen, stdin)) < clen)
		error_exit("Incomplete request message. %d bytes missing.", clen-read);

	for (i = request_len = 0; i < read; i++, request_len++)
		if (request[i] == '+')
			request[request_len] = ' ';
		else if ((request[i] == '%') && (i+2 < read)) {
			request[request_len] = ((request[++i] <= '9'?request[i] - '0':request[i] - 'a' + 10) << 4) |
						 ((request[++i] <= '9'?request[i] - '0':request[i] - 'a' + 10));
		} else
			request[request_len] = request[i];

	if (request_len < 24)
		error_exit("Request message too short. Length = %d.", request_len);

	ip = request;

	id = *(int *)ip;
	ip += 4;

	name_len = ntohl(*(int *)ip);
	ip += 4;
    if ((name_len <= 0) || (name_len > (request_len - 8)))
		error_exit("Invalid server name. Length = %d.", name_len);

	if ((host = malloc(name_len + 1)) == 0)
		error_exit("Error in memory allocation. Length = %d.", name_len);

	bcopy(ip, host, name_len);
	host[name_len] = '\0';

	name_len = ((name_len+3)/4) * 4;
	ip += name_len;

	if (request_len < (name_len + 28))
		error_exit("Request message too short. Length = %d.", request_len);

	prog = ntohl(*(int *)ip);
	ip += 4;
	vers = ntohl(*(int *)ip);
	ip += 4;
	proc = ntohl(*(int *)ip);
	ip += 4;
	prot = ntohl(*(int *)ip)?"tcp":"udp";
	ip += 4;
	timeout_val = ntohl(*(int *)ip);
	ip += 4;
	call_timeout.tv_sec = timeout_val/1000;
	call_timeout.tv_usec = 1000*timeout_val%1000;

	if (logfd)
		fprintf(logfd, "request %s,%d,%d,%s,%d ", host, prog, vers, prot, proc);

	if (secure) {
		hit = FALSE;
		if ((fd = fopen("rpcgw.cfg", "rt")) != 0) {
			while (!feof(fd)) {
				fscanf(fd, "%s %s %s %s %s\n", r_host, r_prog, r_vers, r_prot, r_proc);
				if ((strcmp(r_host, "*") == 0) || ((strcmp(r_host, host) == 0)))
					if ((strcmp(r_prog, "*") == 0) || (atoi(r_prog) == prog))
						if ((strcmp(r_vers, "*") == 0) || (atoi(r_vers) == vers))
							if ((strcmp(r_prot, "*") == 0) || (strcmp(r_prot, prot) == 0))
								if ((strcmp(r_proc, "*") == 0) || (atoi(r_proc) == proc)) {
									hit = TRUE;
									break;
								}
			}
			fclose(fd);
		}
		if (!hit)
			error_exit("Security violation.", 0);
	}

	input_len = request_len - (name_len + 28);
	if ((input_len % 4) != 0)
		error_exit("Invalid XDR input. Length = %d.", input_len);

	output_len_max = MAXREPLY;

	if ((cl = clnt_create(host, prog, vers, prot)) == 0)
		error_exit("Connect to RPC-server failed.", 0);
#ifdef WIN32
	if ((stat = clnt_call(cl, proc, (xdr_proc) xdr_in, ip, (xdr_proc) xdr_out, reply, call_timeout)) != RPC_SUCCESS)
		error_exit(clnt_sperror(cl), 0);
#else
	if ((stat = clnt_call(cl, proc, xdr_in, ip, xdr_out, reply, call_timeout)) != RPC_SUCCESS)
		error_exit(clnt_sperrno(stat), 0);
#endif

#ifdef WIN32
        // Set stdin to binary mode to prevent \r\n conversions.
        _setmode( _fileno( stdout ), _O_BINARY );
#endif
	printf("Content-type: application/octet-stream%c%c",10,10);
	fwrite(&id, 4, 1, stdout);
	fwrite(reply, 1, output_len, stdout);

	if (logfd)
		fprintf(logfd, "successful\n");

	exit(0);
}
