/*
** xsim.c
*/

#include <stdio.h>
#include <math.h>
#include <memory.h>

#include "xsimX.h"

int xsim_red;
int xsim_green;
int xsim_blue;
int xsim_yellow;
int xsim_magenta;
int xsim_cyan;
int xsim_white;
int xsim_black;
int xsim_colors;
int xsim_greys=200;
int xsim_grey0;
int xsim_reds=5;
int xsim_greens=10;
int xsim_blues=2;

int *xsim_grey_index_tab;
int *xsim_color_index_tab;

xsim_window xsim_window_list;

Display *dpy;
GC gc;
int scn;
XSetWindowAttributes attr;
XGCValues gcvalues;
long event_mask;

/*
** INITIALIZATION
*/
void xsim_init()
{
static int inited = 0;

/*
** Open X
*/
if( !inited)
  {
  dpy = XOpenDisplay("");
  scn = DefaultScreen(dpy);
  xsim_init_color_table();
  inited=1;
  xsim_window_list = NULL;
  }
}

void xsim_init_color_table()
{
/*
** Create Color Table
*/
int i,j,k;
Colormap cmap;
XColor color;

cmap = DefaultColormap(dpy,scn);

/*
** First add to the XDefaultColorMap so that these colors will
** be available when capturing from framemaker
*/
color.red = 65535; color.green = 65535; color.blue = 65535; 
XAllocColor(dpy, cmap,&color); xsim_white = color.pixel;

color.red = 0; color.green = 0; color.blue = 0; 
XAllocColor(dpy, cmap,&color); xsim_black = color.pixel;

color.red = 65535; color.green = 0; color.blue = 0;
XAllocColor(dpy, cmap,&color); xsim_red = color.pixel;

color.red = 0; color.green = 65535; color.blue = 0;
XAllocColor(dpy, cmap,&color); xsim_green = color.pixel;

color.red = 0; color.green = 0; color.blue = 65535;
XAllocColor(dpy, cmap,&color); xsim_blue = color.pixel;

color.red = 65535; color.green = 0; color.blue = 65535;
XAllocColor(dpy, cmap,&color); xsim_magenta = color.pixel;

color.red = 0; color.green = 65535; color.blue = 65535;
XAllocColor(dpy, cmap,&color); xsim_cyan = color.pixel;

/*
** This code assumes that X will allocate colors sequentially
** except for black & white
*/

/*
** Allocate line of greys
*/
xsim_grey_index_tab = (int *)malloc(xsim_greys*sizeof(int));
for(i=0;i<xsim_greys;i++)
  {
  color.red =   (float)(i)/(float)xsim_greys*(65535);
  color.green = (float)(i)/(float)xsim_greys*(65535);
  color.blue =  (float)(i)/(float)xsim_greys*(65535);
  XAllocColor(dpy,cmap,&color);
  xsim_grey_index(i) = color.pixel;
  if( color.pixel > xsim_colors ) xsim_colors = color.pixel;
  }
/*
** Allocate Color Cube
*/
xsim_color_index_tab=(int *)malloc(xsim_reds*xsim_greens*xsim_blues*sizeof(int));
for(i=0;i<xsim_reds;i++) for(j=0;j<xsim_greens;j++) for(k=0;k<xsim_blues;k++)
  {
  color.red =   (float)(i)/(float)xsim_reds  *(65535);
  color.green = (float)(j)/(float)xsim_greens*(65535);
  color.blue =  (float)(k)/(float)xsim_blues *(65535);
  XAllocColor(dpy,cmap,&color);
  xsim_color_index(i,j,k) = color.pixel;
  if( color.pixel > xsim_colors ) xsim_colors = color.pixel;
  }
}

/*
** CREATE OBJECT
*/
xsim_object xsim_create_image(rows,cols)
int rows,cols;
{
xsim_object obj;
xsim_image xsimage;
XImage *ximage;
unsigned char *buf;

obj   = (xsim_object) malloc(sizeof(struct xsim_object_s));
xsimage = (xsim_image) malloc(sizeof(struct xsim_image_s));
buf = (unsigned char *) malloc(rows*cols*sizeof(unsigned char));
ximage = XCreateImage(dpy,scn,8,ZPixmap,0,buf,cols,rows,8,0);

xsimage->rows = rows;
xsimage->cols = cols;
xsimage->image = buf;
xsimage->ximage = ximage;

obj->type = XSIM_IMAGE;
obj->obj.image = xsimage;
obj->win = NULL;
obj->next = NULL;

return(obj);
}

xsim_object xsim_create_circle(rad)
float rad;
{
}

xsim_object xsim_create_rectangle(xmin,ymin,xmax,ymax)
float xmin,ymin,xmax,ymax;
{
}

xsim_object xsim_create_polyline(xx,yy,ff,nn)
float xx[],yy[];
int   ff[],nn;
{
int i;
xsim_object   obj;
xsim_polyline mypl;

obj =  (xsim_object)   malloc(sizeof(struct xsim_object_s));
mypl = (xsim_polyline) malloc(sizeof(struct xsim_polyline_s));
mypl->xx = (float *) malloc(nn*sizeof(double));
mypl->yy = (float *) malloc(nn*sizeof(double));
mypl->ff = (int *)   malloc(nn*sizeof(int));

for(i=0 ; i<nn ; i++)
  {
  mypl->xx[i] = xx[i];
  mypl->yy[i] = yy[i];
  mypl->ff[i] = ff[i];
  }
mypl->nn = nn;

obj->x = 0.0; obj->y = 0.0; obj->th = 0.0; obj->shown = 0; obj->scroll = 0;

obj->type = XSIM_POLYLINE;
obj->obj.polyline = mypl;
obj->win = NULL;
obj->next = NULL;

return(obj);
}

xsim_object xsim_create_polymark(xx,yy,nn)
double xx[],yy[];
int   nn;
{
}

xsim_object xsim_create_quadmesh(frows,fcols)
int frows,fcols;
{
}

/*
** DESTROY OBJECT
*/
xsim_destroy_object(obj)
xsim_object obj;
{

if (obj->shown == 1) {
  xsim_undraw_object(obj->win,obj);
}

switch (obj->type)
  {
  case XSIM_IMAGE:
    {
    free(obj->obj);
    free(obj);
    break;
    }
  case XSIM_CIRCLE:
    {
    free(obj->obj);
    free(obj);
    break;
    }
  case XSIM_RECTANGLE:
    {
    free(obj->obj);
    free(obj);
    break;
    }
  case XSIM_POLYLINE:
    {
    free(obj->obj.polyline->xx);
    free(obj->obj.polyline->yy);
    free(obj->obj.polyline->ff);
    free(obj->obj);
    free(obj);
    break;
    }
  case XSIM_POLYMARK:
    {
    free(obj->obj);
    free(obj);
    break;
    }
  case XSIM_QUADMESH:
    {
    free(obj->obj);
    free(obj);
    break;
    }
  }
}

/*
** WINDOW ATTRIBUTES
*/

/*
** Event Handling
*/
xsim_set_event_handler(win,handler)
xsim_window win;
void (*handler)();
{
win->event_handler = handler;
}

/*
** Object Scrolling
*/
xsim_make_object_scroll_window(obj)
xsim_object obj;
{
obj->scroll = 1;
}

/*
** WINDOWS
*/
xsim_window xsim_create_window(name,x,y,height,width)
char name[];
int x,y,height,width;
{
xsim_window win;
Window Xwin;
XEvent event;
XSizeHints hints;

Xwin = XCreateSimpleWindow(dpy,DefaultRootWindow(dpy),x,y,width,height,1,BlackPixel(dpy,scn),WhitePixel(dpy,scn));
XStoreName(dpy,Xwin,name);
gcvalues.foreground = BlackPixel(dpy,scn);
gcvalues.background = WhitePixel(dpy,scn);
gc = XCreateGC(dpy,Xwin,GCForeground, &gcvalues);
event_mask = OwnerGrabButtonMask|ButtonPressMask|ButtonReleaseMask|ButtonMotionMask|KeyPressMask|ExposureMask;
XSelectInput(dpy,Xwin,event_mask);
XMapWindow(dpy,Xwin);
XClearWindow(dpy,Xwin);
XFlush(dpy);
XSync(dpy,0);

win = (xsim_window) malloc(sizeof(struct xsim_window_s));
win->dr = (double) height;
win->dc = (double) width;
win->Xwin = Xwin;
win->display_list = NULL;
win->event_handler = xsim_event_proc;
xsim_add_win(win);
return(win);
}


void xsim_destroy_window(win)
xsim_window win;
/*
** Application is responsible for freeing objects 
** on the display list
*/
{
XDestroyWindow(dpy,win->Xwin);
xsim_del_win(win);
free(win);
}


/*
** DISPLAY LIST MAINTENANCE
*/
void xsim_add_object(win,obj)
xsim_window win;
xsim_object obj;
{
obj->next = win->display_list;
win->display_list = obj;
obj->win = win;
}

xsim_del_object(obj)
xsim_object obj;
{
xsim_window win;
xsim_object tmp;

win = obj->win;

if( win == NULL ) return;
tmp = win->display_list;

if( tmp == obj )
  {
  win->display_list = tmp->next; 
  }
else
  {
  while(tmp->next != NULL && tmp->next != obj) tmp = tmp->next;
  if(tmp->next != NULL) tmp->next = tmp->next->next;
  }
}

/*
** WINDOW LIST MAINTENANCE
*/
void xsim_add_win(win)
xsim_window win;
{
win->next = xsim_window_list;
xsim_window_list = win;
}

xsim_del_win(win)
xsim_window win;
{
xsim_window tmp;

tmp = xsim_window_list;

if( tmp == NULL ) return;

if( tmp == win )
  {
  xsim_window_list = tmp->next; 
  }
else
  {
  while(tmp->next != NULL && tmp->next != win) tmp = tmp->next;
  if(tmp->next != NULL) tmp->next = tmp->next->next;
  }
}

xsim_window xsim_find_xsim_window(xwin)
Window xwin;
/*
** Finds the xsim window structure which corresponds to the 
** given X window
*/
{
xsim_window tmp;

tmp = xsim_window_list;

while( tmp != NULL )
  {
  if(tmp->Xwin == xwin) return(tmp);
  tmp = tmp->next;
  }

return(NULL);
}

/*
** VIEWPORT MANAGEMENT
*/
xsim_clear_window(win)
xsim_window win;
{
XClearWindow(dpy,win->Xwin);
}

void xsim_flush_window(window)
xsim_window window;
{
XFlush(dpy);
}

void xsim_set_viewport(win,x,y,w,h)
xsim_window win;
double x,y,w,h;
{
win->xmin = x-w/2.0;
win->xmax = x+w/2.0;
win->ymin = y-h/2.0;
win->ymax = y+h/2.0;
}

void xsim_set_viewport_3d(win,x,y,z,w,h,d)
xsim_window win;
float x,y,z,w,h,d;
{
}

xsim_set_viewpoint_3d(win,cam,obj,vew,fl)
xsim_window win;
float cam[3]; /* position of camera */
float obj[3]; /* position of subject */
float vew[3]; /* view up vector */
float fl;     /* perspective focal length */
{
}

void xsim_zoom(win,scale)
xsim_window win;
double scale;
/*
** The zooming model is that the world window is mulitplied by scale
** and kept centered
*/
{
double x,y,w,h;

x = (win->xmin+win->xmax)/2.0;
y = (win->ymin+win->ymax)/2.0;
w = win->xmax - win->xmin;
h = win->ymax - win->ymin;

w *= scale; h *= scale;

win->xmin = x - w/2.0;
win->xmax = x + w/2.0;
win->ymin = y - h/2.0;
win->ymax = y + h/2.0;

xsim_clear_window(win);
xsim_set_viewport(win,x,y,w,h);
xsim_render_all(win);
}

void xsim_pan(win,xscale,yscale)
xsim_window win;
double xscale,yscale;
/*
** The panning model is that the world window is shifted by percentages 
** of the current width and height
*/
{
double x,y,w,h;

x = (win->xmin+win->xmax)/2.0;
y = (win->ymin+win->ymax)/2.0;
w = win->xmax - win->xmin;
h = win->ymax - win->ymin;

win->xmin += w*xscale;
win->xmax += w*xscale;
win->ymin += h*yscale;
win->ymax += h*yscale;

x = (win->xmin+win->xmax)/2.0;
y = (win->ymin+win->ymax)/2.0;

xsim_clear_window(win);
xsim_set_viewport(win,x,y,w,h);
xsim_render_all(win);
}

xsim_scroll_window(win,x,y,thresh,scroll)
xsim_window win;
double x,y;
double thresh,scroll;
/*
** thresh is the closeness to the edge required to initiate scrolling
** scroll is the multiple of deviation from the center to scroll by
*/
{
double xmin,xmax,ymin,ymax;
double dxmin,dxmax,dymin,dymax;
double height, width;
double xc,yc;
double dx,dy;
/*
** Scroll window if necessary
*/
xmin = win->xmin; xmax = win->xmax;
ymin = win->ymin; ymax = win->ymax;
xc = (xmax+xmin)/2.0; yc = (ymax+ymin)/2.0;
width = xmax-xmin; height = ymax-ymin;
dx = x - xc; dy = y - yc;

dxmin = (x-xmin)/width;
dxmax = (xmax-x)/width;
dymin = (y-ymin)/height;
dymax = (ymax-y)/height;

if(      dxmin < 0.0  || dymin < 0.0  || dymin < 0.0  || dymax < 0.0 )
  {
  xsim_clear_window(win);
  xsim_set_viewport(win,x,y,width,height);
  xsim_render_all(win);
  }
else if( dxmin < thresh || dxmax < thresh || dymin < thresh || dymax < thresh )
  {
  xsim_clear_window(win);
  if( fabs(dx) > fabs(dy) ) dy = 0.0; else dx = 0.0;
  xsim_set_viewport(win,xc+scroll*dx,yc+scroll*dy,width,height);
  xsim_render_all(win);
  }
}

/*
** DRAW
*/
xsim_render_all(win)
xsim_window win;
{
xsim_object obj;

obj = win->display_list;
while( obj != NULL)
  {
  if( obj->shown ) 
    xsim_render_object(win,obj,obj->x,obj->y,obj->th,obj->color,XSIM_XOR);
  obj = obj->next;
  }
}

xsim_draw_object(win,obj,x,y,th,color)
xsim_window win;
xsim_object obj;
double x,y,th;
int color;
{
double xs,ys,ths;
int   mode,cs;

if( !(obj->win == NULL || obj->win == win) )
  {
  printf("cannot draw same object into two windows\n");
  return;
  }

if(obj->type == XSIM_IMAGE) 
  mode = XSIM_COPY;
else 
  mode = XSIM_XOR;

if( obj->scroll ) 
  xsim_scroll_window(win,obj->x,obj->y,0.05,1.95);

if( !obj->shown )
  {
  xsim_render_object(win,obj,x,y,th,color,mode);
  obj->x = x; obj->y = y; obj->th = th; obj->color = color; obj->shown = 1;
  xsim_add_object(win,obj);
  }
else
  {
  xs = obj->x; ys = obj->y; ths = obj->th; cs = obj->color;
  xsim_render_object(win,obj,x,y,th,color,mode);    
  xsim_render_object(win,obj,xs,ys,ths,cs,mode);    
  obj->x = x; obj->y = y; obj->th = th; obj->color = color; obj->shown = 1;
  }

}

/*
** UNDRAW
*/
void xsim_undraw_object(win,obj)
xsim_window win;
xsim_object obj;
{
xsim_render_object(win,obj,obj->x,obj->y,obj->th,obj->color,XSIM_XOR);    
obj->shown=0;
xsim_del_object(obj);
}

/*
** RENDERS
*/
xsim_render_object(win,obj,x,y,th,color,mode)
xsim_window win;
xsim_object obj;
double x,y,th;
int color,mode;
{
switch (obj->type)
  {
  case XSIM_IMAGE:     
    xsim_render_image(win,obj,x,y,th,color,mode); break;
  case XSIM_CIRCLE:    
    xsim_render_circle(win,obj,x,y,th,color,mode); break;
  case XSIM_RECTANGLE: 
    xsim_render_rectangle(win,obj,x,y,th,color,mode); break;
  case XSIM_POLYLINE:  
    xsim_render_polyline(win,obj,x,y,th,color,mode); break;
  case XSIM_POLYMARK:  
    xsim_render_polymark(win,obj,x,y,th,color,mode); break;
  }
}

xsim_render_image(win,obj,x,y,th,color,mode)
xsim_window win;
xsim_object obj;
double x,y,th;
int   mode;
{
xsim_image img;
img = obj->obj.image;
XPutImage(dpy,win->Xwin,gc,img->ximage,0,0,0,0,img->cols,img->rows);
}

xsim_render_pixel(win,row,col,color,mode)
xsim_window win;
int row,col,color,mode;
{
printf("not implemented\n");
}

xsim_render_circle(win,circle,x,y,th,color,mode)
xsim_window win;
xsim_object circle;
double x,y,th;
int   mode;
{
printf("not implemented\n");
}

xsim_render_rectangle(win,rect,x,y,th,color,mode)
xsim_window win;
xsim_object rect;
double x,y,th;
int   mode;
{
printf("not implemented\n");
}

xsim_render_polyline(win,pl,x,y,th,color,mode)
xsim_window win;
xsim_object pl;
double x,y,th;
int   color,mode;
{
int i;
double x1,y1,x2,y2;
XSegment *segs;
int nsegs;

nsegs = 0;

segs = (XSegment *) malloc(xsim_polyline_n(pl)*sizeof(XSegment));

for (i=1;i<xsim_polyline_n(pl);i++)
 {
 if( xsim_polyline_f(pl,i) )
  {
  body_to_world(xsim_polyline_x(pl,i-1),xsim_polyline_y(pl,i-1),&x1,&y1,x,y,th);
  body_to_world(xsim_polyline_x(pl,i-0),xsim_polyline_y(pl,i-0),&x2,&y2,x,y,th);
  world_to_pixel(win,x1,y1,&(segs[nsegs].y1),&(segs[nsegs].x1));
  world_to_pixel(win,x2,y2,&(segs[nsegs].y2),&(segs[nsegs].x2));
  /*
  printf("xb: %lf yb:%lf",xsim_polyline_x(pl,i-1),xsim_polyline_y(pl,i-1));
  printf("xw: %lf yw:%lf",x1,y1);
  printf("xs: %lf ys:%lf\n",segs[nsegs].x1,segs[nsegs].y2);
  */
  nsegs++;
  }
 }

XSetFunction(dpy,gc,mode);
XSetForeground(dpy,gc,color);
XDrawSegments(dpy,win->Xwin,gc,segs,nsegs);
XFlush(dpy);
XSync(dpy,0);
free(segs);
}

xsim_render_polymark(win,pm,x,y,th,color,mode)
xsim_window win;
xsim_object pm;
double x,y,th;
int   mode;
{
printf("not implemented\n");
}

xsim_render_quadmesh(win,mesh,color,mode)
xsim_window win;
xsim_object mesh;
int   color,mode;
{
}

/*
** EVENT HANDLING
*/
void xsim_event_proc(dpy, event, win)
Display *dpy;
XEvent *event;
xsim_window win;
{
if( event->type == KeyPress )
  {
  char text[1];
  int count;
  count = XLookupString(event,text,1,0,0);
  if(count >0) xsim_keypress_handler(text[0]);
  }
else if(event->type == ButtonPress )
 {
  switch(event->xbutton.button)
  {
  case 1: xsim_mouse_handler(event->xbutton.x,event->xbutton.y,DOWN_LEFT);break;
  case 2: xsim_mouse_handler(event->xbutton.x,event->xbutton.y,DOWN_MIDDLE);break;
  case 3: xsim_mouse_handler(event->xbutton.x,event->xbutton.y,DOWN_RIGHT);break;
  } 
 }
else if(event->type == ButtonRelease )
  {
  switch(event->xbutton.button)
    {
    case 1: xsim_mouse_handler(event->xbutton.x,event->xbutton.y,UP_LEFT);break;
    case 2: xsim_mouse_handler(event->xbutton.x,event->xbutton.y,UP_MIDDLE);break;
    case 3: xsim_mouse_handler(event->xbutton.x,event->xbutton.y,UP_RIGHT);break;
    } 
  }
else if(event->type == MotionNotify )
  {
  xsim_mouse_handler(event->xbutton.x,event->xbutton.y,DRAG);
  }
else if(event->type == Expose )
  {
  xsim_expose_handler(win,event->xany.display,event->xany.window);
  }
}

void xsim_mouse_handler(mx, my, action)
int mx, my;
int action;
{
switch (action) 
  {
  case UP_LEFT: printf("xsim_mouse_handler: UP_LEFT\n"); break;
  case DOWN_LEFT: printf("xsim_mouse_handler: DOWN_LEFT\n"); break;
  case UP_MIDDLE: printf("xsim_mouse_handler: UP_MIDDLE\n"); break;
  case DOWN_MIDDLE: printf("xsim_mouse_handler: DOWN_MIDDLE\n"); break;
  case UP_RIGHT: printf("xsim_mouse_handler: UP_RIGHT\n"); break;
  case DOWN_RIGHT: printf("xsim_mouse_handler: DOWN_RIGHT\n"); break;
  case DRAG: printf("xsim_mouse_handler: DRAG\n"); break;
  case MOVE: printf("xsim_mouse_handler: MOVE\n"); break;
  }
}

void xsim_keypress_handler(c)
char c;
{
printf("xsim_keypress_handler: %c\n",c);
}

void xsim_expose_handler(xsim_win,dpy,win)
xsim_window xsim_win;
Display * dpy;
Window win;
{
Window root;
int x,y;
unsigned int w,h,border,depth;

XGetGeometry(dpy,win,&root,&x,&y,&w,&h,&border,&depth);

xsim_win->dr = h;
xsim_win->dc = w;

xsim_clear_window(xsim_win);
xsim_render_all(xsim_win);
}

/*
** EVENT SOLICITING
*/
void xsim_display_block()
{
XEvent event;
xsim_window xsim_win;

while(!XCheckMaskEvent(dpy,event_mask,&event)) ;
xsim_win = xsim_find_xsim_window(event.xany.window);
if(xsim_win != NULL)(*(xsim_win->event_handler))(dpy,event,xsim_win);
}

int xsim_display_poll()
{
XEvent event;
xsim_window xsim_win;

while(XCheckMaskEvent(dpy,event_mask,&event))
  {
  xsim_win = xsim_find_xsim_window(event.xany.window);
  if(xsim_win != NULL)(*(xsim_win->event_handler))(dpy,event,xsim_win);
  }
}
