/* 
 *
 *
 * DEEPAK BAPNA
 * November 22, 1993 
 * 
 * 15-881 - Assignment4-  Dynamic Convex Hull Algorithm
 * Due date: November 29, 1993
 *
 * This program constitutes problem 2 of the assignment- implementing
 * a dynamic convex hull algorithm.
 *
 * The graphics library used here is from "simulator"- a simulator
 * designed for 16-761: Introduction to mobile robots. 
 *
 * NOTE:
 * The following algorithm assumes that initially three points are
 * provided in proper order: such that traversing the binary tree from
 * minimum element is equivalent to traversing the triangle in
 * anticlockwise sense.
*/

#include <stdio.h>   /*standard header files */
#include <ctype.h>
#include <string.h>
#include <math.h>

#include "matrix.h"  /* simulator files */
#include "xsimX.h"
#include "xtools.h"

xsim_window world_window;

typedef struct point1 {        /*structure for points */
  float x;
  float y;
} point;

typedef struct line1 {         /*structure for lines */
  point p1;
  point p2;
} line;

typedef struct dat {         /*data structure used as a part of binary */
			     /*tree*/ 
  point pt;
  struct tnode *prev;
  struct tnode *next;
} node_data;

typedef struct tnode {       /* binary tree: doubly connected */
  node_data  *data;
  struct tnode *left;
  struct tnode *right;
} treenode;

#define Pi  3.141592653589

/*......................................................................*/

init_graphics()               /* setting the graphics environment */
{
float x,y,w,h;
xsim_init();

xtools_load_world_file("world.wld");

world_window = xsim_create_window("World",world_r0,world_c0,world_dr,world_dc); 
xsim_set_event_handler(world_window,xtools_event_proc);
sleep(2);

x = (world_x0+world_xf)/2.0; y = (world_y0+world_yf)/2.0;
w = (world_xf-world_x0);     h = (world_yf-world_y0);
xsim_set_viewport(world_window,x,y,w,h);
xtools_render_world();
}

/*......................................................................*/

Draw_point(p)             /* A function to draw points using simulator */
			  /* functions */
point p;
{
xtools_render_cross(p.x,p.y,0.25);
}

/*......................................................................*/

/* A function to draw polygon. Input is pointer to the root of tree 
 * defining the polygon 
*/

Draw_polygon(root)      
treenode *root;
{
  treenode *p0;
  float x1, y1, x2, y2;
  p0 = root;
  
  while(root != p0->data->next){
    x1 = p0->data->pt.x;  x2 = p0->data->next->data->pt.x; 
    y1 = p0->data->pt.y;  y2 = p0->data->next->data->pt.y; 
    xtools_render_line(x1,y1,x2,y2,xsim_black,XSIM_XOR);
    p0 = p0->data->next;
  }
xtools_render_line(p0->data->pt.x, p0->data->pt.y, root->data->pt.x,
		   root->data->pt.y, xsim_black,XSIM_XOR);
}
/*......................................................................*/

/* make allocation for data */

node_data *dalloc()
{
return (node_data *) malloc(sizeof(struct dat));
}

/* make a tnode */

treenode *talloc()
{
return (treenode *) malloc(sizeof(struct tnode));
}

/*......................................................................*/

/* Building the initial hull. It is assumed that the points are passed 
 * in order of angle.                                                    
*/ 

treenode *Initialize_hull(p,p0,p1,p2,centroid)
point p0,p1,p2;
point *centroid;
treenode *p;
{
treenode *left_1, *right_1;  

     
    p = talloc(); left_1 = talloc(); right_1 = talloc();
    p->data = dalloc(); left_1->data = dalloc(); right_1->data = dalloc();

    p->data->pt.x = p1.x;
    p->data->pt.y = p1.y;
    p->data->prev = left_1;
    p->data->next = right_1;
    p->left = left_1;
    p->right = right_1;

    left_1->data->pt.x = p0.x;
    left_1->data->pt.y = p0.y;
    left_1->data->prev = right_1;
    left_1->data->next = p;
    left_1->left = NULL;
    left_1->right = NULL;

    right_1->data->pt.x = p2.x;
    right_1->data->pt.y = p2.y;
    right_1->data->prev = p;
    right_1->data->next = left_1;
    right_1->left = NULL;
    right_1->right = NULL; 

(*centroid).x = (p0.x + p1.x + p2.x )/3.0;
(*centroid).y = (p0.y + p1.y + p2.y)/3.0;
return p;
}

/*....................................................................*/

/* let's define a routine to find the left most and right most element 
 * of the branch starting at p
*/ 

treenode *left_most(p)
treenode *p;
{
if (p->left == NULL)
return p;
return left_most(p->left);
}

treenode *right_most(p)
treenode *p;
{
if (p->right == NULL)
return p;
return right_most(p->right);
}

/*......................................................................*/

/* Finding out the minimum and the maximum element in a queue starting 
 *at the node p. 
*/

treenode *min_elt(p)
treenode *p;
{
return left_most(p);
}

treenode *max_elt(p)
treenode *p;
{
return right_most(p);

}
/*......................................................................*/

/* print tree in order */

void Treeprint(p)
treenode *p;
{
  if (p != NULL) 
    {
      Treeprint(p->left);
      printf("%2f %2f\n", p->data->pt.x, p->data->pt.y);
      Treeprint(p->right);
    }
}


/*......................................................................*/

float angle(node,p0) /* Calculating the angle from p0 to root of the */
		     /* node from the horizontal */
point p0;
treenode *node;
{
float ang1;
point p1;
p1.x = node->data->pt.x;
p1.y = node->data->pt.y;
ang1 = atan2(p1.y - p0.y,p1.x - p0.x);
if (ang1 < 0.0) ang1 = ang1 + 2 * Pi;
return ang1;
}

/*......................................................................*/

/* Define crossproduct of two lines (p1-p0) x (p2- p0) */

float cross_product (p0,p1,p2)
point p0,p1, p2;
{
return ((p1.x - p0.x) * (p2.y - p0.y) - (p1.y - p0.y) * (p2.x - p0.x));
}

/* Following function calculates cross-product (m-q) x (r - q) */ 

int Cross_product(root,p0)
treenode *root;
point p0;
{
float cp;
int temp;
cp = cross_product(p0,min_elt(root)->data->pt,root->data->pt);
if (cp >= 0) temp = 1;
else temp = 0;
return temp;
}

/*......................................................................*/

/*             
* Following routine classify a vertex as reflex, concave or  support.             
* Mostly we need to find out if root or minimum is a support. So let's
* define two functions which give us the classificaion of root or the
* minimum element with respect to a new point.   
*/

int Root_class(root,p0)  /* classify root of a subtree */
     treenode *root;
     point p0;
{
  float cp1, cp2;
  int value;
  cp1 = cross_product(root->data->pt,p0,root->data->next->data->pt);
  cp2 = cross_product(root->data->pt,p0,root->data->prev->data->pt);
  if ((cp1 >  0) && (cp2 < 0)) 
    { value = -1;
     /* printf ("vertex is reflex \n"); */}
  else if ((cp1 <  0) && (cp2 > 0)) 
    {value = 1;
     /*printf ("vertex is concave \n");*/}
  else 
    {value = 0;
     /*printf ("vertex is supporting \n");*/}
  return value;
}

int Min_class(root,p0) /* classify minimum element of a subtree */
treenode *root;
point p0;
{
  float cp1, cp2;
  int value;
  cp1 =
    cross_product(min_elt(root)->data->pt,p0,min_elt(root)->data->next->data->pt);   
  cp2 =
    cross_product(min_elt(root)->data->pt,p0,min_elt(root)->data->prev->data->pt);  
  if ((cp1 >  0) && (cp2 < 0)) 
    { value = -1;
      /*printf ("vertex is reflex \n");*/}
  else if ((cp1 <  0) && (cp2 > 0)) 
    {value = 1;
     /*printf ("vertex is concave \n");*/}
  else 
    {value = 0;
     printf ("vertex is supporting \n");}
  return value;
} 



/*......................................................................*/

/* Following function searches for the left supporting vertex */

treenode *Left_search(p,p0)
     treenode *p;
     point p0;
{ 
treenode *temp;
    
    temp = talloc();
    temp->data = dalloc(); 

  if (Root_class(p,p0) == 0) {temp = p ;
 printf("%f %f \n",temp->data->pt.x,temp->data->pt.y);}
  else {
    if (Root_class(p,p0) == -1) temp = Left_search(p->left,p0);
    else temp = Left_search(p->right,p0);
  }
return temp; 
}

/*......................................................................*/

/* Following function searches for the right supporting vertex*/

treenode *Right_search(p,p0)
     treenode *p;
     point p0;
{ 
treenode *temp;
    
    temp = talloc();
    temp->data = dalloc(); 

  if (Root_class(p,p0) == 0) {
      temp = p ;
      printf("%f %f \n",temp->data->pt.x,temp->data->pt.y);}
  else {
    if (Root_class(p,p0) == -1) temp = Right_search(p->right,p0);
    else temp = Right_search(p->left,p0);
  }
return temp; 
}

/*......................................................................*/

/* 
 * Following functions update the convex hull after supporting 
 * vertices are found. "update_1" updates for vl > vr, while
 * "update_2"  updates for vl < vr.
*/

treenode *update_1(root,vl,vr,p0)
treenode *root, *vl, *vr;
point p0;
{
treenode *new;

  new = talloc();
  new->data = dalloc(); 

  new->data->pt.x = p0.x;
  new->data->pt.y = p0.y;

  new->left = NULL;
  new->right = NULL;

  new->data->next =  vr;
  new->data->prev = vl;

  vl->right = NULL;
  vr->left = new;

  vr->data->prev = new;
  vl->data->next = new;
  
return root;
}

/*......................................................................*/

/* update function for vl < vr */

treenode *update_2(root,vl,vr,p0)
treenode *root, *vl, *vr;
point p0;
{
treenode *new;

  new = talloc();
  new->data = dalloc(); 

  new->data->pt.x = p0.x;
  new->data->pt.y = p0.y;

  new->left = vl;
  new->right = vr;

  new->data->next =  vr;
  new->data->prev = vl ;

  vl->right = NULL;
  vr->left = NULL;

  vr->data->prev = new;
  vl->data->next = new;

 root = new;  

return root;
}

/*......................................................................*/
/* 
 *
 * Main function to insert a new point and find the resultant convex  
 * hull. Root is the tree representing the current convex hull and p0
 * is the new point to be inserted.
 * 
 * Input: Pointer to the current convex_hull; and a new point.
 * Action: Update Hull
 * Output: A pointer to the updated hull.
 *
*/

treenode *Update_hull(root,p0)
treenode *root;
point p0;
{
treenode *l1, *l2, *new, *vr, *vl;

    l1 = talloc(); l2 = talloc(); 
    l1->data = dalloc(); l2->data = dalloc(); 
    vr = talloc(); vl = talloc(); 
    vr->data = dalloc(); vl->data = dalloc();

/* Case 1 */
if (Cross_product(root,p0) && (Min_class(root, p0) == 1) &&
    (Root_class(root,p0) == 1))
  { 
    printf("case1 \n");
    if (root->right == NULL) {printf("Internal_Point \n"); return root;}
    else root->right = Update_hull(root->right,p0);
    
  }

/* CASE 2 */
if (Cross_product(root,p0) && (Min_class(root, p0) == 1) &&
    (Root_class(root,p0) != 1))
  {
    printf("case2 \n");
    l1 = Left_search(root,p0);
    l2 = Right_search(root->right,p0);
    root = update_2(root,l1,l2,p0); Treeprint(root); return root;
  }

/* CASE 3 */
if (Cross_product(root,p0) && (Min_class(root, p0) != 1) &&
    (Root_class(root,p0) == -1))
  {
    printf("case3 \n");
    root->left = Update_hull(root->left,p0);
  }

/* CASE 4 */
if (Cross_product(root,p0) && (Min_class(root, p0) != 1) &&
    (Root_class(root,p0) != -1))
  { 
    printf("case4 \n");
    l1 = Left_search(root,p0); 
    l2 = Right_search(root->left,p0);
    root = update_1(root,l1,l2,p0); return root;
  }

/* CASE 5 */
if ((Cross_product(root,p0) == 0) && (Min_class(root, p0) == -1) &&
    (Root_class(root,p0) == -1))
  {
    printf("case5 \n");
    root->right = Update_hull(root->right,p0);
  }

/* CASE 6 */
if ((Cross_product(root,p0) == 0) && (Min_class(root, p0) == -1) &&
    (Root_class(root,p0) != -1))
  {
    printf("case6 \n");
    l1 = Left_search(root->right,p0);
    l2 = Right_search(root,p0);
    root = update_1(root,l1,l2,p0); return root;
  }

/* CASE 7 */
if ((Cross_product(root,p0) == 0) && (Min_class(root, p0) != -1) &&
    (Root_class(root,p0) == 1))
  {
    printf("case7 \n");
    if (root->left == NULL) {printf("Internal_Point \n"); return root;}
    root->left = Update_hull(root->left,p0);
  }

/* CASE 8 */
if ((Cross_product(root,p0) == 0) && (Min_class(root, p0) != -1) &&
    (Root_class(root,p0) != 1)) 
  {
    printf("case8 \n");
    l1 = Left_search(root->left,p0);
    l2 = Right_search(root,p0);
    root = update_2(root,l1,l2,p0); return root;
  } 

/*free(l1); free(l2); 
  free(l1->data); free(l2->data); */

return root;
}

/*......................................................................*/

/* Yet another function to draw polygons */

Poly_convert(p,poly_array,i)
treenode *p;
point poly_array[300];
int *i;
{
  if (p != NULL) 
    {
      Poly_convert(p->left,poly_array,i);
      poly_array[*i].x = p->data->pt.x;
      poly_array[*i].y = p->data->pt.y;
      *i = *i + 1;
      Poly_convert(p->right,poly_array,i);
    }
}

/*......................................................................*/

Draw_polygon_1(root)
     treenode *root;
{
  int i,j;  
  float x1, y1, x2, y2;
  point temp_poly[300];

  i = 0;
  Poly_convert(root,temp_poly,&i);
  printf ("%d \n",i);
  printf("check \n");
  for(j = 0; j <i ; j++){
    printf("%f %f \n",temp_poly[j].x,temp_poly[j].y);
  }
  temp_poly[i].x = temp_poly[0].x;
  temp_poly[i].y = temp_poly[0].y;
  
  printf("drawing polygon \n");
  for(j = 0; j <= i-1 ; j++){
    xtools_render_line(temp_poly[j].x,temp_poly[j].y,temp_poly[j+1].x,temp_poly[j+1].y,xsim_black,XSIM_XOR);   
    printf("%f %f \n",temp_poly[j].x,temp_poly[j].y);   
  }
}

/*......................................................................*/


main()
{
  treenode *root;
  point p0,p1,p2,p3,p4;
  point centroid;
  point poly_array[300];
  int i,j;
  
  root = NULL;  /* Initilizes the convex_hull to Null */ 
  

  init_graphics();  /* Initialises graphics- puts window on the screen */

  p3.x = 20.0;  /* Initial points to built a triangle */ 
  p3.y = 15.0;
  p1.x = 15.0;
  p1.y = 20.0;
  p2.x = 10.0;
  p2.y = 15.0;

  root = Initialize_hull(root,p3,p1,p2); /* first hull based on the */
					 /* three points */

  Treeprint(root);
  Draw_point(p1);
  Draw_point(p2);
  Draw_point(p3);
  Draw_polygon(root);
  
  
  while(1)
    {
      printf("give new point\n");
      scanf("%f %f",&p0.x,& p0.y);
      printf("newpoint to be added is  ");
      Draw_point(p0);
      printf("%f %f \n", p0.x, p0.y); 
      Draw_polygon_1(root);
      root = Update_hull(root,p0);
      Draw_polygon_1(root); 
      sleep(2);
      printf("Updated_polygon  is \n");
      Treeprint(root);
    } 
  
  return 0;
}

