
typedef struct {
  int   id;
  float ang;
} beacon_list;


extern float sensor_x;
extern float sensor_y;
extern float sensor_yaw;
extern float sensor_maxr;
extern float sensor_fov;
extern int   sensor_pixels;

extern float K_len;
extern float N_len;
extern float K_gm;
extern float N_gm;
extern float K_r;
extern float N_r;
extern float K_alp;
extern float N_alp;
extern float K_phi;
extern float N_phi;

extern int   world_n;
extern int   world_i;
extern int   world_r0;
extern int   world_c0;
extern int   world_dr;
extern int   world_dc;
extern float world_x0;
extern float world_y0;
extern float world_xf;
extern float world_yf;
extern int   world_pi[];
extern int   world_vi[];
extern float world_x1[];
extern float world_y1[];
extern float world_x2[];
extern float world_y2[];

extern float robot_width;
extern float robot_height;

extern float goal_x;
extern float goal_y;
extern int   start_n;
extern float start_x[];
extern float start_y[];

extern int beacon_n;
extern float beacon_x[];
extern float beacon_y[];

extern xsim_object xtools_create_robot();
extern xsim_object xtools_create_hmmwv();
extern void xtools_event_proc();
extern void xtools_mouse_handler();
extern void xtools_keypress_handler();
extern xsim_window xtools_make_signal_window();
extern xsim_window xtools_get_window();
extern void generate_beacon_scan();

extern float normalize();

float XR;
float YS;
float XV;
float YR;

#define image_to_polar(i,a) \
*a = ((float)(i)/(float)(sensor_pixels-1)-0.5)*sensor_fov;

#define polar_to_image(a,i) \
*i = (int)((a/sensor_fov+0.5)*(sensor_pixels-1));

#define polar_to_sensor(r,a,xs,ys) \
*xs = r * cos(a+M_PI/2.0); \
*ys = r * sin(a+M_PI/2.0);

#define sensor_to_polar(xs,ys,r,a) \
*r = sqrt(xs*xs+ys*ys); \
*a = atan2(ys,xs) - M_PI/2.0;

#define sensor_to_robot(xs,ys,xr,yr) \
*xr = sensor_x + xs*cos(sensor_yaw) - ys*sin(sensor_yaw); \
*yr = sensor_y + xs*sin(sensor_yaw) + ys*cos(sensor_yaw);

#define robot_to_sensor(xr,yr,xs,ys) \
*xs =   (xr-sensor_x)*cos(sensor_yaw) + (yr-sensor_y)*sin(sensor_yaw); \
*ys = - (xr-sensor_x)*sin(sensor_yaw) + (yr-sensor_y)*cos(sensor_yaw);

#define robot_to_global(xr,yr,xg,yg,x,y,th) \
*xg = x + xr*cos(th) - yr*sin(th); \
*yg = y + xr*sin(th) + yr*cos(th);

#define global_to_robot(xg,yg,xr,yr,x,y,th) \
*xr =   (xg-x)*cos(th) + (yg-y)*sin(th); \
*yr = - (xg-x)*sin(th) + (yg-y)*cos(th);

#define polar_to_robot(r,a,xr,yr) \
polar_to_sensor(r,a,&XR,&YS); \
sensor_to_robot(XR,YS,xr,yr);

#define robot_to_polar(xr,yr,r,a) \
robot_to_sensor(xr,yr,&XR,&YS); \
sensor_to_polar(XR,YS,r,a);

#define polar_to_global(r,a,xg,yg,x,y,th) \
polar_to_sensor(r,a,&XR,&YS); \
sensor_to_robot(XR,YS,&XV,&YR); \
robot_to_global(XV,YR,xg,yg,x,y,th);

#define global_to_polar(xg,yg,r,a,x,y,th) \
global_to_robot(xg,yg,&XV,&YR,x,y,th); \
robot_to_sensor(XV,YR,&XR,&YS); \
sensor_to_polar(XR,YS,r,a);









