#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#define XSIM_XOR GXxor
#define XSIM_COPY GXcopy

#define XSIM_2D 2
#define XSIM_3D 3

#define UP_LEFT     1
#define DOWN_LEFT   2
#define UP_MIDDLE   3
#define DOWN_MIDDLE 4
#define UP_RIGHT    5
#define DOWN_RIGHT  6
#define DRAG        7
#define MOVE        8

#define xsim_quadmesh_x(object,i,j) \
object->obj.quadmesh->xx[object->obj.quadmesh->cols*(i) + (j)]

#define xsim_quadmesh_y(object,i,j) \
object->obj.quadmesh->yy[object->obj.quadmesh->cols*(i) + (j)]

#define xsim_quadmesh_z(object,i,j) \
object->obj.quadmesh->zz[object->obj.quadmesh->cols*(i) + (j)]

#define xsim_quadmesh_f(object,i,j) \
object->obj.quadmesh->ff[object->obj.quadmesh->cols*(i) + (j)]

#define xsim_polyline_x(object,i) object->obj.polyline->xx[i]
#define xsim_polyline_y(object,i) object->obj.polyline->yy[i]
#define xsim_polyline_f(object,i) object->obj.polyline->ff[i]
#define xsim_polyline_n(object)   object->obj.polyline->nn

#define xsim_image_pixel(object,row,col) \
  (object->obj.image->image[object->obj.image->cols*(row) + (col)])

#define xsim_grey_index(g) xsim_grey_index_tab[g]

#define xsim_color_index(r,g,b) \
xsim_color_index_tab[xsim_greens*xsim_blues*r+xsim_blues*g+b]

typedef enum
  {
  XSIM_IMAGE,
  XSIM_CIRCLE,
  XSIM_RECTANGLE,
  XSIM_POLYLINE,
  XSIM_POLYMARK,
  XSIM_QUADMESH
  } xsim_object_t;

typedef union
  {
  struct xsim_image_s      *image;
  struct xsim_circle_s     *circle;
  struct xsim_rectangle_s  *rectangle;
  struct xsim_polyline_s   *polyline;
  struct xsim_polymark_s   *polymark;
  struct xsim_quadmesh_s   *quadmesh;
  } xsim_object_u;

struct xsim_object_s
  {
  xsim_object_u    obj;
  xsim_object_t    type;
  float x;
  float y;
  float th;
  int   color;
  int   shown;
  int   scroll;
  struct xsim_window_s  *win;
  struct xsim_object_s  *next;
  };
typedef struct xsim_object_s *xsim_object;

struct xsim_polyline_s
  {
  float *xx;
  float *yy;
  int   *ff;
  int   nn;
  };
typedef struct xsim_polyline_s *xsim_polyline;

struct xsim_image_s
{
  int rows,cols;
  XImage *ximage;
  unsigned char *image;
};
typedef struct xsim_image_s *xsim_image;

struct xsim_circle_s
  {
  float x,y,r;
  };
typedef struct xsim_circle_s *xsim_circle;

struct xsim_rectangle_s
  {
  float xmin,ymin,xmax,ymax;
  };
typedef struct xsim_rectangle_s *xsim_rectangle;

struct xsim_polymark_s
  {
  float *xx;
  float *yy;
  int   *ff;
  int   nn;
  };
typedef struct xsim_polymark_s *xsim_polymark;

struct xsim_quadmesh_s
  {
  int rows;
  int cols;
  float *xx;
  float *yy;
  float *zz;
  int   *ff;
  int   nn;
  };
typedef struct xsim_quadmesh_s *xsim_quadmesh;

struct xsim_window_s
  {
  float 	xmin,ymin,xmax,ymax;
  float 	dr,dc;
  Window 	Xwin;
  xsim_object 	display_list;
  struct 	xsim_window_s  *next;
  void          (*event_handler)();
  };
typedef struct xsim_window_s *xsim_window;

extern Display *dpy;
extern GC gc;
extern int scn;
extern XSetWindowAttributes attr;
extern XGCValues gcvalues;

extern int xsim_red;
extern int xsim_green;
extern int xsim_blue;
extern int xsim_yellow;
extern int xsim_magenta;
extern int xsim_cyan;
extern int xsim_white;
extern int xsim_black;
extern int xsim_colors;
extern int xsim_grey0;
extern int xsim_greys;
extern int xsim_reds;
extern int xsim_greens;
extern int xsim_blues;

extern int *xsim_grey_index_tab;
extern int *xsim_color_index_tab;

void 		xsim_init();
void 		xsim_init_color_table();
xsim_window     xsim_create_window();
xsim_window	xsim_find_xsim_window();
xsim_object   	xsim_create_polyline();
xsim_object   	xsim_create_polymark();
xsim_object   	xsim_create_image();
xsim_object   	xsim_create_quadmesh();
int         	xsim_destroy_polyline();
int 		xsim_draw_polyline();
void		xsim_undraw_object();
void 		xsim_event_proc();
void		xsim_keypress_handler();
void 		xsim_mouse_handler();
void 		xsim_expose_handler();
void		xsim_add_win();

#define world_to_pixel(win,x,y,r,c)\
{\
float x0,y0,xf,yf,dr,dc;\
\
x0 = win->xmin; y0 = win->ymin;\
xf = win->xmax; yf = win->ymax;\
dr = win->dr;   dc = win->dc;\
\
*r = (1.0-(y-y0)/(yf-y0))*dr;\
*c =      (x-x0)/(xf-x0) *dc;\
}

#define body_to_world(xb,yb,xw,yw,x,y,th)\
{\
*xw = x + xb*cos(th) - yb*sin(th);\
*yw = y + xb*sin(th) + yb*cos(th);\
}

